export interface Campaign {
  id: number;
  title: string;
  user_id: number;
  advert_type: string;
  media_type: string;
  status: string;
  remind_to_upload: boolean;
  user_notes: string;
  admin_notes: string;
}
export interface CommuneSuggestion {
  state_id: string;
  state_name: string;
  country_name: string;
  city_name: string;
  city_id: string;
  country_id: string;
  postal_code: string;
  lat: string;
  lng: string;
}

export interface LocationResult {
  state_id: string;
  state_name: string;
  country_name: string;
  city_name: string;
  city_id: string;
  country_id: string;
  postal_code: string;
  lat: string;
  lng: string;
}

export interface LocationSearchResponse {
  status: number;
  getResult: LocationResult[];
}
export interface CommuneHub {
  id: number;
  commune_name: string;
  postal_code: number;
  commune_slug: string;
  commune_id: number;
  image1: string | null;
  image2: string | null;
  image3: string | null;
  tile_image: string | null;
  heading: string;
  subheading: string;
  description: string;
  seo_title: string;
  seo_description: string;
  seo_keywords: string[];
}

export interface PromoCodeInfo {
  currentBalance?: number;
  availableBalance?: number;
  walletBalance?: number;
  balance?: number;
  code?: string;
  discount?: string;
  status?: string;
}