import React from "react";
import Link from "next/link";
import "./AdvertTable.css";

export default function PricingTable() {
  return (
    <>
      <div className="pricetable-one " id="pricing-table-card">
        <div className="container-price">
          <h1 className="main-title">Nos offres sous la loupe</h1>
          <p className="main-subtitle">
            *Tout est gratuit pendant notre Test Beta
          </p>

          <div className="pricing-wrapper">
            <div className="table-row header-row">
              <div className="cell info-cell-1">
                <h2>Nos offres</h2>
                <p>
                  Toutes les communes ont un niveau de géoprix selon la taille
                  de leur population.
                </p>
              </div>
              {/* column1 */}
              <div className="cell pricing-cell card-base">
                <div className="icon">
                  <img
                    src="advert-info/Asset row1.svg"
                    alt=""
                    className="icon-imge"
                  />
                </div>
                <div className="badge">Base</div>
                <div className="price-circule-parent">
                  <div className="price-circle">
                    <div className="price-main">0€</div>
                  </div>
                </div>
              </div>
              {/* ..... */}

              {/*column2  */}
              <div className="cell pricing-cell card-booster">
                <div className="icon">
                  <img
                    src="advert-info/Asset row2.svg"
                    alt=""
                    className="icon-imge"
                  />
                </div>
                <div className="badge">booster</div>
                <div className="price-circule-parent">
                  <div className="price-circle ">
                    <span className="price-sub">dès </span>

                    <span className="price-main">1€</span>
                    <span className="price-sub-2"> jour </span>
                  </div>
                </div>
              </div>
              {/* column 3 */}
              <div className="cell pricing-cell card-city">
                <div className="icon">
                  <img
                    src="advert-info/Asset row3.svg"
                    alt=""
                    className="icon-imge"
                  />
                </div>
                <div className="badge">City Hub</div>
                <div className="price-circule-parent">
                  <div className="price-circle">
                    <span className="price-sub">dès</span>
                    <span className="price-main">75€</span>
                    <span className="price-sub-2"> sem</span>
                  </div>
                </div>
              </div>
              {/* column 4 */}
              <div className="cell pricing-cell card-categorie">
                <div className="icon">
                  <img
                    src="advert-info/price-table4img.png"
                    alt=""
                    className="icon-imge"
                  />
                </div>
                <div className="badge">catégorie</div>
                <div className="price-circule-parent">
                  <div className="price-circle">
                    <span className="price-sub">dès</span>
                    <span className="price-main">90€</span>
                    <span className="price-sub-2"> sem</span>
                  </div>
                </div>
              </div>
            </div>

            {/* Row 1: Statistiques de performance */}
            <div className="table-row-2">
              <div className="cell info-cell-2">
                <div className="feature-title">Statistiques de performance</div>
                <div className="feature-subtitle">
                  Mesurez l'impact et l'audience
                </div>
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <img src="/cross.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <span className="feature-text">Basiques</span>
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <span className="feature-text">Détaillées</span>
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <span className="feature-text">Détaillées</span>
              </div>
            </div>

            {/* Row 2: Durée minimum de la publicité */}
            <div className="table-row-2">
              <div className="cell info-cell-3">
                <div className="feature-title">
                  Durée minimum de la publicité
                </div>
                <div className="feature-subtitle">
                  La période d'affichage de votre campagne
                </div>
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <span className="feature-text">Illimitée</span>
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <span className="feature-text">Illimitée</span>
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <span className="feature-text">7 jours</span>
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <span className="feature-text">7 jours</span>
              </div>
            </div>

            {/* Row 3: Images */}
            <div className="table-row-2">
              <div className="cell info-cell-4">
                <div className="feature-title">Images</div>
                <div className="feature-subtitle">
                  Tous pour suivre vos campagnes
                </div>
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick1.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <span className="feature-text">Plusieurs formats</span>
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 4: Texte enrichi */}
            <div className="table-row-2">
              <div className="cell info-cell-5">
                <div className="feature-title">Texte enrichi</div>
                <div className="feature-subtitle">
                  Tous pour suivre vos campagnes
                </div>
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <img src="/cross.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <span className="feature-text">Plusieurs formats</span>
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 5: Vidéo intégrée */}
            <div className="table-row-2">
              <div className="cell info-cell-6">
                <div className="feature-title">Vidéo intégrée</div>
                <div className="feature-subtitle">
                  Ajouter des contenus dynamiques
                </div>
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <img src="/cross.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick2.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 6: EventX Partner Icon */}
            <div className="table-row-2">
              <div className="cell info-cell-7">
                <div className="feature-title">EventX Partner Icon</div>
                <div className="feature-subtitle">
                  Bénéficiez d'un badge partenaire exclusif
                </div>
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <img src="/cross.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <img src="/cross-blue.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 7: Positionnement prioritaire */}
            <div className="table-row-2">
              <div className="cell info-cell-8">
                <div className="feature-title">Positionnement prioritaire</div>
                <div className="feature-subtitle">Placement avantageux</div>
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <img src="/cross.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <img src="/cross-blue.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 8: Partage sur réseaux sociaux */}
            <div className="table-row-2">
              <div className="cell info-cell-3">
                <div className="feature-title">Partage sur réseaux sociaux</div>
                <div className="feature-subtitle">
                  Partage social automatique
                </div>
              </div>
              <div className="cell-2 feature-cell feature-cell-dark">
                <span className="feature-text">Limitée</span>
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick2.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 9: Ciblage géographique */}
            <div className="table-row-2">
              <div className="cell info-cell-4">
                <div className="feature-title">Ciblage géographique</div>
                <div className="feature-subtitle">
                  Ciblage local ou national
                </div>
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick1.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick2.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 10: Modification en temps réel */}
            <div className="table-row-2">
              <div className="cell info-cell-5">
                <div className="feature-title">Modification en temps réel</div>
                <div className="feature-subtitle">
                  Modifications instantanées
                </div>
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick1.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick2.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-dark">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            {/* Row 11: Lien vers site externe */}
            <div className="table-row-2">
              <div className="cell info-cell-6">
                <div className="feature-title">Lien vers site externe</div>
                <div className="feature-subtitle">
                  Lien vers votre site ou page de réservation
                </div>
              </div>
              <div className="cell-2 feature-cell feature-cell-light">
                <img src="/cross.png" alt="" className="check-base" />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick2.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick3.svg"
                  alt=""
                  className="check-base"
                />
              </div>
              <div className="cell-2 feature-cell-2 feature-cell-light">
                <img
                  src="/advert-info/Asset tick4.svg"
                  alt=""
                  className="check-base"
                />
              </div>
            </div>

            <div className="table-row cta-row">
              <div className="cell info-cell-9"></div>
              <div className="cell cta-cell">
                <Link
                  href="https://www.eventx.fr/dashboard/add_event_default"
                  className="cta-button btn-base"
                >
                  GO !
                </Link>
              </div>
              <div className="cell cta-cell">
                <Link
                  href="/campaigns/createSepCampaigns"
                  className="cta-button btn-booster"
                >
                  GO !
                </Link>
              </div>
              <div className="cell cta-cell">
                <Link
                  href="/campaigns/createHubPageAdvert"
                  className="cta-button btn-city"
                >
                  GO !
                </Link>
              </div>
              <div className="cell cta-cell">
                <Link
                  href="/campaigns/createCategoryPageAdvert"
                  className="cta-button btn-categorie"
                >
                  GO !
                </Link>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
