
import Navbar from "../../app/components/navbar/Navbar";
import Sidebar from "../../app/components/sidebar/Sidebar";
import { AuthWrapper } from "@/app/components/auth/authWrapper";
export default function MainLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
        <AuthWrapper>

     <div className="bg-[#E0EBF6] p-3 lg:px-12 lg:py-8 h-full">
           <div className="bg-white  p-3 lg:p-5 min-h-screen rounded-2xl border border-[grey]">
            <Navbar/>
            <Sidebar/>
             <div className="lg:mt-5 ml-[0rem] lg:ml-[3rem] ">
               <main className="container-main">{children}</main>
             </div>
           </div>
      </div>
        </AuthWrapper>
  );
}