'use client';

import { useState } from 'react';
import './MediaLibrary.css';

export default function MediaLibrary() {
  const [searchQuery, setSearchQuery] = useState('');
  const [activeFilter, setActiveFilter] = useState('Tous');
  const [isFocused, setIsFocused] = useState(false);

  const filters = ['Tous', 'Images', 'Vidéos', 'Contenu riche'];

  return (
    <div className="media-library">
      {/* Main Heading */}
      <h1 className="main-heading">MA BIBLIOTHÈQUE DE MÉDIAS</h1>

      {/* Blue Section with Search and Filters */}
      <div className="blue-section">
        <div className="blue-content">
          {/* Search Bar */}
          <div className="search-container">
            <span className="search-label">Search</span>
            <div className="search-wrapper">
              <input
                type="text"
                value={searchQuery}
                onChange={(e) => setSearchQuery(e.target.value)}
                onFocus={() => setIsFocused(true)}
                onBlur={() => setIsFocused(false)}
                placeholder=""
                className="search-input"
              />
              {/* show icon only when input is NOT focused AND empty */}
              {(!isFocused && searchQuery.trim() === '') && (
                <img
                  className="search-icon"
                  src="/images/Asset 29.svg"
                  alt="search icon"
                />
              )}
            </div>
          </div>

          {/* Filter Section */}
          <div className="filter-container">
            <span className="filter-label">Filter : </span>
            <div className="filter-buttons">
              {filters.map((filter, index) => (
                <span key={filter} className="filter-item">
                  <button
                    onClick={() => setActiveFilter(filter)}
                    className={`filter-btn ${activeFilter === filter ? 'active' : ''}`}
                  >
                    {filter}
                  </button>
                  {index < filters.length - 1 && (
                    <span className="filter-separator">|</span>
                  )}
                </span>
              ))}
            </div>
          </div>
        </div>
      </div>

      {/* Required File Dimensions Section */}
      <div className="dimensions-section">
        {/* Button with Arrow */}
        <button className="dimensions-btn">
          REQUIRED FILE DIMENSIONS
          <img className="arrow-icon" src="/images/Asset 30.svg" alt="" />
        </button>

        {/* Paragraph */}
        <div className="info-box">
          <p className="info-text">
            There are varying advert sizes throughout the EventX site.
          </p>
          <p className="info-text">
            To ensure you use the correct size, please check the dropdown for all the correct sizes to upload.
          </p>
        </div>
      </div>

      {/* Add Media Button and File Info */}
      <div className="bottom-section">
        <button className="add-media-btn">+ ADD MÉDIA</button>
        <p className="file-info">
          Types autorisés : JPG, PNG, MP4, PDF, TXT, DOCX
          <span className="filter-separator-para-content"> | </span>
          Taille max : 25 Mo par fichier
        </p>
      </div>
    </div>
  );
}
