import React from "react";
import Image from "next/image";
import "./MicrosoftSignIn.css";

interface MicrosoftSignInProps {
  text?: string;
  className?: string;
  disabled?: boolean;
  backendUrl?: string;
  onBeforeRedirect?: () => void;
}

export const MicrosoftSignIn: React.FC<MicrosoftSignInProps> = ({
  text = "Continuer avec Microsoft",
  className = "",
  disabled = false,
  backendUrl,
  onBeforeRedirect,
}) => {
  const handleMicrosoftSignIn = () => {
    if (disabled) return;

    if (onBeforeRedirect) {
      onBeforeRedirect();
    }

    const apiUrl = backendUrl || process.env.NEXT_PUBLIC_API_URL_New;

    if (!apiUrl) {
      console.error(
        "Backend URL is not configured. Please provide backendUrl prop or set NEXT_PUBLIC_API_URL_New environment variable."
      );
      return;
    }

    window.location.href = `${apiUrl}/auth/microsoft`;
  };

  return (
    <div
      className={`color-block block-black-reg ${className}`}
      onClick={handleMicrosoftSignIn}
      style={{
        cursor: disabled ? "not-allowed" : "pointer",
        opacity: disabled ? 0.6 : 1,
      }}
    >
      <div className="block-black-icon-container-register">
        <Image
          src="/login/microsoft.png"
          alt="Icône Microsoft"
          width={24}
          height={24}
          className="block-icon"
        />
      </div>
      <div className="block-black-text-content-reg">
        <div className="primary-black-text-reg">{text}</div>
      </div>
    </div>
  );
};

export default MicrosoftSignIn;
