// components/HeaderCard.tsx - UPDATED VERSION
import React from 'react';
import Image from 'next/image';

interface HeaderCardProps {
  /**
   * Logo image source
   */
  logoSrc?: string;
  /**
   * Logo alt text
   */
  logoAlt?: string;
  /**
   * Logo width
   */
  logoWidth?: number;
  /**
   * Logo height
   */
  logoHeight?: number;
  /**
   * Title text
   */
  title?: string;
  /**
   * Title CSS class name
   */
  titleClassName?: string;
  /**
   * Container CSS class name
   */
  className?: string;
  /**
   * Whether to use the original styling
   */
  useOriginalStyling?: boolean;
  /**
   * Image CSS class name
   */
  imageClassName?: string;
  /**
   * Direction of the header (horizontal or vertical)
   */
  direction?: 'horizontal' | 'vertical';
}

const HeaderCard: React.FC<HeaderCardProps> = ({
  logoSrc = "/login/logo_1.png",
  logoAlt = "", // Changed to empty string to match original
  logoWidth = 65,
  logoHeight = 60,
  title = "Mot de passe oublié ?",
  titleClassName = "",
  className = "",
  useOriginalStyling = true,
  imageClassName = "",
  direction = 'horizontal',
}) => {
  // For original styling, use the original class names
  const containerClasses = useOriginalStyling 
    ? `forgot-password-image-forg ${className}`
    : `header-card ${className}`;

  const titleClasses = useOriginalStyling
    ? `forgot-password-title ${titleClassName}`
    : `header-card-generic-title ${titleClassName}`;

  // For original styling, don't add image class (matches original code)
  // For generic styling, add the header-card-logo class
  const imageClasses = useOriginalStyling
    ? `${imageClassName}`.trim()
    : `header-card-logo ${imageClassName}`;

  const containerStyle = direction === 'vertical' 
    ? { flexDirection: 'column' as const, textAlign: 'center' as const }
    : {};

  return (
    <div 
      className={containerClasses} 
      style={containerStyle}
    >
      <Image 
        src={logoSrc} 
        alt={logoAlt} 
        width={logoWidth} 
        height={logoHeight}
        className={imageClasses}
        priority
      />
      <p className={titleClasses}>{title}</p>
    </div>
  );
};

export default HeaderCard;