// app/features/campaign/campaignSlice.ts
import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { Campaign } from "@/app/types";
import { fetchCommuneHubs } from "@/app/redux/services/main/campaigns/mycampaign";
import { fetchEventHubUserCampaigns } from "@/app/redux/services/main/campaigns/evenhubcampaigns";
// Campaign Form State Interface
export interface CampaignEventHubFormState {
  media_type: string;
  advert_type: string;
  advert_redirect_url?: string;
  startDate: string;
  endDate: string;
  price: number;
  commune: string;
  postcode: string;
  format: string;
  title: string;
  duration: number;
  image: string;
  commune_id: string;
  booster: boolean;
  booster_price: string;
  page_id: string;
  activity_title?: string;
  activity_commune?: string;
  activity_dates?: string;
  activity_prices?: string;
  activity_description?: string;
  // events: any[];
}

interface CampaignEventHubState {
  campaignseventhub: Campaign[];
  selectedCampaignEventHub: Campaign | null;
  campaignFormEventHub: CampaignEventHubFormState;
  selectedEvents: CampaignEventHubFormState[];
  communeHubs: any[];
  eventHubCompaigns: any[];
  loading: boolean;
  error: string | null;
  success: boolean;
  loadingCommuneHubs: boolean;
}

const initialFormState: CampaignEventHubFormState = {
  media_type: "image",
  advert_type: "large",
  advert_redirect_url: "",
  startDate: "",
  endDate: "",
  price: 0,
  title: "",
  commune: "",
  postcode: "",
  format: "400 X 350px",
  duration: 0,
  image: "",
  commune_id: "",
  booster: false,
  booster_price: "",
  page_id: "",
  activity_title: "",
  activity_commune: "",
  activity_dates: "",
  activity_prices: "",
  activity_description: "",
};

const initialState: CampaignEventHubState = {
  campaignseventhub: [],
  selectedCampaignEventHub: null,
  campaignFormEventHub: initialFormState,
  selectedEvents: [],
  eventHubCompaigns: [],
  communeHubs: [],
  loading: false,
  error: null,
  success: false,
  loadingCommuneHubs: false,
};

export const eventHubSlice = createSlice({
  name: "eventhub",
  initialState,
  reducers: {
    setSelectedCampaign: (state, action: PayloadAction<Campaign | null>) => {
      state.selectedCampaignEventHub = action.payload;
    },
    clearSelectedCampaign: (state) => {
      state.selectedCampaignEventHub = null;
    },

    updateCampaignEventHubFormAlt: (
      state: CampaignEventHubState,
      action: PayloadAction<{
        key: keyof CampaignEventHubFormState;
        value: string | number | any[] | boolean;
      }>
    ) => {
      const { key, value } = action.payload;
      (state.campaignFormEventHub as any)[key] = value;
    },

    setCampaignForm: (
      state,
      action: PayloadAction<Partial<CampaignEventHubFormState>>
    ) => {
      state.campaignFormEventHub = {
        ...state.campaignFormEventHub,
        ...action.payload,
      };
    },

    resetCampaignForm: (state) => {
      state.campaignFormEventHub = initialFormState;
    },

    resetCampaignState: () => initialState,
    resetPrice: (state) => {
      state.campaignFormEventHub.price = 0;
    },
  },
  extraReducers: (builder) => {
    builder
      // Handle fetchCommuneHubs actions
      .addCase(fetchCommuneHubs.pending, (state) => {
        state.loadingCommuneHubs = true;
        state.error = null;
      })
      .addCase(fetchCommuneHubs.fulfilled, (state, action) => {
        state.loadingCommuneHubs = false;
        state.communeHubs = action.payload.data;
      })
      .addCase(fetchCommuneHubs.rejected, (state, action) => {
        state.loadingCommuneHubs = false;
        state.error = action.payload as string;
      })
      .addCase(fetchEventHubUserCampaigns.pending, (state) => {
        state.loadingCommuneHubs = true;
        state.error = null;
      })
      .addCase(fetchEventHubUserCampaigns.fulfilled, (state, action) => {
        state.loadingCommuneHubs = false;
        state.eventHubCompaigns = action.payload.data;
      })
      .addCase(fetchEventHubUserCampaigns.rejected, (state, action) => {
        state.loadingCommuneHubs = false;
        state.error = action.payload as string;
      });
  },
});

export const {
  setSelectedCampaign,
  clearSelectedCampaign,
  updateCampaignEventHubFormAlt,
  setCampaignForm,
  resetCampaignForm,
  resetCampaignState,
  resetPrice,
} = eventHubSlice.actions;

export default eventHubSlice.reducer;
