import React from "react";
import Image from "next/image";
import "./GoogleSignIn.css";

interface GoogleSignInProps {
  text?: string;
  className?: string;
  disabled?: boolean;
  backendUrl?: string;
  onBeforeRedirect?: () => void;
}

export const GoogleSignIn: React.FC<GoogleSignInProps> = ({
  text = "Continuer avec Google",
  className = "",
  disabled = false,
  backendUrl,
  onBeforeRedirect,
}) => {
  const handleGoogleSignIn = () => {
    if (disabled) return;

    // Execute optional callback before redirect
    if (onBeforeRedirect) {
      onBeforeRedirect();
    }

    // Get backend URL from prop or environment variable
    const apiUrl = backendUrl || process.env.NEXT_PUBLIC_API_URL_New;

    if (!apiUrl) {
      console.error(
        "Backend URL is not configured. Please provide backendUrl prop or set NEXT_PUBLIC_API_URL_New environment variable."
      );
      return;
    }

    // Redirect to backend Google OAuth endpoint
    window.location.href = `${apiUrl}/auth/google`;
  };

  return (
    <div
      className={`color-block block-red-reg ${className}`}
      onClick={handleGoogleSignIn}
      style={{
        cursor: disabled ? "not-allowed" : "pointer",
        opacity: disabled ? 0.6 : 1,
      }}
    >
      <div className="block-red-icon-container-register">
        <Image
          src="/login/google.png"
          alt="Icône Google"
          width={24}
          height={24}
          className="block-icon"
        />
      </div>
      <div className="block-red-text-content">
        <div className="primary-red-text-reg">{text}</div>
      </div>
    </div>
  );
};

export default GoogleSignIn;
