"use client";

import React, { useState } from "react";
import "./verifyCode.css";
import Image from "next/image";
import { useRouter } from "next/navigation";
import { verifyResetCode } from "../../../redux/services/auth/authServices";
import { useDispatch } from "react-redux";
import FormInput from "@/app/components/auth/commons/cards/Lable";
import HeaderCard from "@/app/components/auth/commons/cards/HeadingCard";
import SubHeaderCard from "@/app/components/auth/commons/cards/SubHeadingCard";
import Swal from "sweetalert2";
export const VerifyCode = ({
  email,
  setResetPassword,
  verificationCode,
  setVerificationCode,
}: {
  email: any;
  setResetPassword: any;
  verificationCode: any;
  setVerificationCode: any;
}) => {
  const router = useRouter();
  const handleBackClick = () => {
    router.back();
  };
  const dispatch = useDispatch();
  const [isLoading, setIsLoading] = useState(false);
  const handleVerifyCode = async () => {
    setIsLoading(true);
    try {
      const result = await dispatch(
        verifyResetCode({
          email,
          code: verificationCode,
        }) as any
      ).unwrap();
      Swal.fire({
        icon: "success",
        title: "Code vérifié !",
        text: "Le code de vérification a été validé avec succès !",
        confirmButtonText: "OK",
      });
      setResetPassword(true);
    } catch (error: unknown) {
      const errorMessage =
        error instanceof Error ? error.message : String(error);

      Swal.fire({
        icon: "error",
        title: "Échec de la vérification",
        text: "",
        confirmButtonText: "OK",
      });
    } finally {
      setIsLoading(false);
    }
  };
  return (
    // <div className="split-verify-container">

    <div className="white-verify-center-container">
      <button
        className="mobile-back-button"
        onClick={handleBackClick}
        aria-label="Go back"
      >
        <Image
          src="/login/arrow_email.png"
          alt="Retour"
          width={24}
          height={24}
          className="block-icon"
        />
      </button>
      <div className="verify-password-content">
        <HeaderCard
          logoSrc="/login/logo_1.png"
          logoAlt=""
          logoWidth={65}
          logoHeight={60}
          title="Mot de passe oublié ?"
          useOriginalStyling={true}
        />
        <SubHeaderCard
          line1="Aucun problème ! Remplissez le formulaire ci-dessous"
          line2="Nous vous reconnecterons à votre compte en quelques clics"
          useOriginalStyling={true}
        />
        <div className="email-input-container">
          <FormInput
            label="Code de vérification"
            name="email-input"
            type="text"
            value={verificationCode}
            onChange={(fieldName, fieldValue) =>
              setVerificationCode(fieldValue)
            }
            placeholder="Saisissez votre adresse e-mail"
            required
            containerWidth="full"
          />
        </div>
        <div className="retrieve-verify-password-button">
          <button
            className="blue-verify-button"
            disabled={isLoading}
            onClick={handleVerifyCode}
          >
            {isLoading ? "Vérification..." : "Vérifier"}
            <Image
              src="/login/arrow.png"
              alt="Récupérer"
              width={16}
              height={16}
              className="button-icon"
              style={{ marginLeft: "5px" }}
            />
          </button>
        </div>
      </div>
    </div>
    // </div>
    // </div>
  );
};
