"use client";

import StripeProvider from './StripProvider';
import PaymentForm from './PaymentForm';

interface CheckoutProps {
  clientSecret: string;
  onSuccess?: () => void;
}

export default function Checkout({ clientSecret, onSuccess }: CheckoutProps) {
  return (
    <StripeProvider clientSecret={clientSecret}>
      <PaymentForm onSuccess={onSuccess} />
    </StripeProvider>
  );
}