import Cookies from "js-cookie";

export const getToken = (): string | undefined => {
  return Cookies.get("token");
};

export const removeToken = (): void => {
  Cookies.remove("token");
};

export const hasToken = (): boolean => {
  return !!Cookies.get("token");
};

export const getUserInfo = (): any | null => {
  if (typeof window === "undefined") {
    return null;
  }
  try {
    const userInfo = Cookies.get("user_info");

    if (userInfo) {
      return JSON.parse(userInfo);
    }
    return null;
  } catch (error) {
    Cookies.remove("user_info");
    return null;
  }
};
export const getUserId = (): any | null => {
  if (typeof window === "undefined") {
    return null;
  }

  const userId = Cookies.get("user_id");
  return userId || null;
};
export const getPromoCode = (): any | null => {
  if (typeof window === "undefined") {
    return null;
  }
  // try {
  const promoCode = Cookies.get("promo_code");
  return promoCode || null;
};
export const logout = (): void => {
  Cookies.remove("token");

  if (typeof window !== "undefined") {
    localStorage.removeItem("user_info");
    localStorage.removeItem("user_id");
    localStorage.removeItem("stripe_coupon_id");
    localStorage.removeItem("promo_code");

    Cookies.remove("user_info");
    Cookies.remove("user_id");
    Cookies.remove("stripe_coupon_id");
    Cookies.remove("promo_code");
    Cookies.remove("token");
    Cookies.remove("stripe_customer_id");
    Cookies.remove("promo_code_assigned");
  }
};
