// components/InvoiceModal.tsx
import React from "react";
import "./invoice.css";
interface InvoiceModalProps {
  isOpen: boolean;
  onClose: () => void;
  invoiceData: any;
}

const InvoiceModal: React.FC<InvoiceModalProps> = ({
  isOpen,
  onClose,
  invoiceData,
}) => {
  if (!isOpen) return null;
  const items = invoiceData.items || createInvoiceItemsFromAdverts(invoiceData);
  const totalHT = items.reduce((sum: number, item: any) => sum + item.total, 0);
  const creationDate = formatDate(
    invoiceData.created_at || new Date().toISOString()
  );
  const invoiceNumber = invoiceData.campaignId;
  // invoiceData.invoiceNumber ||
  // `FAC/${new Date().getFullYear()}/${invoiceData.campaignId}`;
  const discountValue = invoiceData.discount || 0;
  // const totalAfterDiscount = totalHT - discountValue;

  return (
    <div className="price-selector-modal-overlay">
      <div
        className="price-selector-modal-content"
        style={{ maxWidth: "800px", width: "95%" }}
      >
        <div className="invoice-modal-content">
          {/* Invoice HTML content */}
          <div className="LetterHeadContainer-Main">
            <div className="LetterHeadContainer">
              {/* LetterHead Header */}
              <div className="LetterHeadHeader">
                <div className="invoice-header-main-leftside">
                  <div className="LetterHeadLogo">
                    <div className="resize-icon">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 64.95 22.53"
                        className="resize-icon"
                      >
                        <defs>
                          <style>
                            {`
        .cls-1 {
          filter: url(#drop-shadow-1);
        }
        .cls-2 {
          fill: #231f20;
        }
        .cls-3 {
          fill: #2fa8df;
        }
        .cls-4 {
          fill: #ea2129;
        }
        .cls-5 {
          fill: #0992c0;
        }
        .cls-6 {
          fill: #f04f49;
        }
      `}
                          </style>
                          <filter
                            id="drop-shadow-1"
                            x="31.66"
                            y="-3.69"
                            width="56.88"
                            height="52.56"
                            filterUnits="userSpaceOnUse"
                          >
                            <feOffset dx="8.5" dy="11.34" />
                            <feGaussianBlur result="blur" stdDeviation="5" />
                            <feFlood floodColor="#fff" floodOpacity="1" />
                            <feComposite in2="blur" operator="in" />
                            <feComposite in="SourceGraphic" />
                          </filter>
                        </defs>
                        <g id="Layer_1-2" data-name="Layer 1">
                          <g>
                            <g>
                              <g className="cls-1">
                                <path
                                  className="cls-4"
                                  d="M42.13,22.53c-.28-.02-.55-.02-.83,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0-.17-.02-.34-.01-.51,0-.05-.08.02-.12.06-.17.14-.21.29-.41.44-.62.02-.03.04-.06.06-.09.21-.24.39-.5.56-.76.09-.1.17-.2.23-.31.14-.15.25-.31.35-.48.2-.24.38-.49.55-.75.05-.02.07-.07.09-.12.21-.25.4-.51.57-.79.05-.03.08-.08.1-.14.2-.23.37-.48.54-.73.12-.14.24-.29.33-.45.1-.09.16-.22.24-.33.42-.54.82-1.09,1.21-1.66.07-.09.13-.18.2-.27.16-.19.3-.38.43-.59.13-.16.26-.32.36-.5.09-.08.16-.18.22-.29.22-.28.43-.56.62-.86,0-.01.02-.02.02-.03.2-.24.38-.49.55-.76.09-.09.17-.2.23-.32.13-.18.29-.35.4-.55.42-.54.82-1.1,1.21-1.66.02-.02.03-.05.05-.07.08-.08.15-.17.2-.27.22-.29.44-.59.66-.88.5-.69,1-1.38,1.5-2.07.08-.09.16-.18.21-.29.14-.16.26-.33.37-.51.42-.54.82-1.09,1.21-1.66.01-.01.02-.03.03-.04.21-.27.42-.53.6-.82.08-.08.15-.17.2-.27.15-.16.27-.34.38-.52.16-.22.32-.44.48-.66.05-.04.09-.1.12-.16.22-.27.42-.54.6-.83.05-.04.09-.09.11-.16.06-.06.13-.08.21-.08.2,0,.4,0,.61,0,.26.02.53.02.79,0,.29.02.58.02.87,0,.26,0,.52,0,.78.01,0,.09-.06.14-.09.21-.15.27-.3.53-.46.8-.1.12-.18.25-.23.4-.11.15-.2.3-.27.47-.17.25-.32.51-.45.78-.06.07-.11.15-.14.24-.14.2-.26.41-.37.63-.14.24-.28.48-.42.72-.02.03-.04.07-.06.1-.17.28-.34.55-.49.84-.35.54-.66,1.1-.97,1.65-.04.08-.09.16-.13.23-.12.17-.23.36-.32.55-.18.28-.36.57-.51.87-.03.02-.04.04-.04.07-.16.22-.29.47-.42.71-.33.54-.66,1.09-.96,1.66-.11.15-.2.31-.27.47-.09.12-.18.25-.23.4-.17.25-.32.51-.45.78-.05.05-.09.11-.11.19-.15.22-.28.45-.4.68-.17.25-.33.52-.46.79-.03.02-.04.05-.04.08-.18.25-.33.51-.46.79-.11.17-.22.34-.3.52-.07.07-.12.16-.15.26-.19.28-.35.57-.51.87-.08.1-.15.21-.2.34-.11.14-.19.29-.27.45-.18.28-.35.56-.5.86-.01.02-.02.04-.03.06-.17.23-.3.48-.43.73-.33.53-.64,1.07-.94,1.62-.11.15-.2.3-.27.47-.1.13-.19.27-.25.43-.16.26-.32.52-.47.78-.05,0-.09,0-.14,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0-.28-.02-.55-.02-.83,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0-.28-.02-.55-.02-.83,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0Z"
                                />
                                <path
                                  className="cls-3"
                                  d="M64.47,16.22c.15.15.31.28.48.4-.04.07-.12.05-.18.05-1.44,0-2.89,0-4.33,0-.1,0-.19-.03-.27-.09-.22-.16-.43-.34-.67-.48-.08-.08-.17-.15-.27-.19-.16-.14-.33-.27-.52-.38-.54-.43-1.09-.83-1.66-1.22-.03-.02-.06-.04-.09-.06-.24-.21-.5-.4-.77-.57-.09-.08-.19-.16-.3-.22-.15-.14-.31-.25-.48-.36-.55-.42-1.09-.83-1.66-1.21,0-.03,0-.05-.01-.08.02-.04.04-.08.06-.12.17-.24.31-.49.43-.75.34-.54.66-1.09.96-1.65.08-.13.17-.27.25-.4.07.05.14.1.2.15.47.37.92.77,1.4,1.13.25.23.52.45.8.65.04.06.09.1.16.13.22.21.46.4.71.59.1.11.21.21.35.28.13.14.27.26.44.35.03.03.05.06.08.09.45.36.89.73,1.34,1.09.37.29.71.61,1.1.88.01.01.03.02.04.04.23.23.49.42.75.62.1.08.21.17.31.25.17.17.35.31.55.44.13.13.27.25.43.35.11.12.23.22.37.3Z"
                                />
                                <path
                                  className="cls-3"
                                  d="M39.69,1.57c-.51-.38-1.02-.77-1.53-1.15.04-.06.08-.04.11-.04,2.21,0,4.43,0,6.64,0,.1,0,.17.03.25.09.1.08.19.18.31.24.12.12.25.22.39.32.12.12.25.23.39.32.09.08.18.17.28.24.46.37.89.76,1.37,1.1.28.26.58.5.88.73.04.06.09.1.16.13.2.19.4.36.63.51.09.11.21.2.33.27.17.16.34.31.54.44.48.43.99.83,1.49,1.23-.5.69-1,1.38-1.5,2.07-.22.3-.44.59-.66.88-.07-.04-.13-.09-.2-.13-.14-.12-.29-.24-.45-.33-.1-.1-.2-.19-.33-.24-.27-.23-.56-.43-.86-.63-.26-.21-.52-.41-.8-.59-.07-.08-.15-.14-.25-.18-.19-.17-.4-.32-.62-.45-.33-.25-.66-.5-.99-.74-.48-.35-.95-.73-1.46-1.06-.12-.11-.25-.2-.38-.28-.15-.14-.3-.26-.48-.35-.54-.42-1.09-.83-1.66-1.22-.03-.05-.07-.07-.12-.08-.21-.18-.43-.35-.67-.49-.12-.12-.26-.22-.42-.3-.12-.12-.27-.22-.41-.31Z"
                                />
                              </g>
                              <path
                                className="cls-6"
                                d="M42.13,22.53c-.28-.02-.55-.02-.83,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0-.17-.02-.34-.01-.51,0-.05-.08.02-.12.06-.17.14-.21.29-.41.44-.62.02-.03.04-.06.06-.09.21-.24.39-.5.56-.76.09-.1.17-.2.23-.31.14-.15.25-.31.35-.48.2-.24.38-.49.55-.75.05-.02.07-.07.09-.12.21-.25.4-.51.57-.79.05-.03.08-.08.1-.14.2-.23.37-.48.54-.73.12-.14.24-.29.33-.45.1-.09.16-.22.24-.33.42-.54.82-1.09,1.21-1.66.07-.09.13-.18.2-.27.16-.19.3-.38.43-.59.13-.16.26-.32.36-.5.09-.08.16-.18.22-.29.22-.28.43-.56.62-.86,0-.01.02-.02.02-.03.2-.24.38-.49.55-.76.09-.09.17-.2.23-.32.13-.18.29-.35.4-.55.42-.54.82-1.1,1.21-1.66.02-.02.03-.05.05-.07.08-.08.15-.17.2-.27.22-.29.44-.59.66-.88.5-.69,1-1.38,1.5-2.07.08-.09.16-.18.21-.29.14-.16.26-.33.37-.51.42-.54.82-1.09,1.21-1.66.01-.01.02-.03.03-.04.21-.27.42-.53.6-.82.08-.08.15-.17.2-.27.15-.16.27-.34.38-.52.16-.22.32-.44.48-.66.05-.04.09-.1.12-.16.22-.27.42-.54.6-.83.05-.04.09-.09.11-.16.06-.06.13-.08.21-.08.2,0,.4,0,.61,0,.26.02.53.02.79,0,.29.02.58.02.87,0,.26,0,.52,0,.78.01,0,.09-.06.14-.09.21-.15.27-.3.53-.46.8-.1.12-.18.25-.23.4-.11.15-.2.3-.27.47-.17.25-.32.51-.45.78-.06.07-.11.15-.14.24-.14.2-.26.41-.37.63-.14.24-.28.48-.42.72-.02.03-.04.07-.06.1-.17.28-.34.55-.49.84-.35.54-.66,1.1-.97,1.65-.04.08-.09.16-.13.23-.12.17-.23.36-.32.55-.18.28-.36.57-.51.87-.03.02-.04.04-.04.07-.16.22-.29.47-.42.71-.33.54-.66,1.09-.96,1.66-.11.15-.2.31-.27.47-.09.12-.18.25-.23.4-.17.25-.32.51-.45.78-.05.05-.09.11-.11.19-.15.22-.28.45-.4.68-.17.25-.33.52-.46.79-.03.02-.04.05-.04.08-.18.25-.33.51-.46.79-.11.17-.22.34-.3.52-.07.07-.12.16-.15.26-.19.28-.35.57-.51.87-.08.1-.15.21-.2.34-.11.14-.19.29-.27.45-.18.28-.35.56-.5.86-.01.02-.02.04-.03.06-.17.23-.3.48-.43.73-.33.53-.64,1.07-.94,1.62-.11.15-.2.3-.27.47-.1.13-.19.27-.25.43-.16.26-.32.52-.47.78-.05,0-.09,0-.14,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0-.28-.02-.55-.02-.83,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0-.28-.02-.55-.02-.83,0-.26-.02-.53-.02-.79,0-.01,0-.03,0-.04,0Z"
                              />
                              <path
                                className="cls-5"
                                d="M64.47,16.22c.15.15.31.28.48.4-.04.07-.12.05-.18.05-1.44,0-2.89,0-4.33,0-.1,0-.19-.03-.27-.09-.22-.16-.43-.34-.67-.48-.08-.08-.17-.15-.27-.19-.16-.14-.33-.27-.52-.38-.54-.43-1.09-.83-1.66-1.22-.03-.02-.06-.04-.09-.06-.24-.21-.5-.4-.77-.57-.09-.08-.19-.16-.3-.22-.15-.14-.31-.25-.48-.36-.55-.42-1.09-.83-1.66-1.21,0-.03,0-.05-.01-.08.02-.04.04-.08.06-.12.17-.24.31-.49.43-.75.34-.54.66-1.09.96-1.65.08-.13.17-.27.25-.4.07.05.14.1.2.15.47.37.92.77,1.4,1.13.25.23.52.45.8.65.04.06.09.1.16.13.22.21.46.4.71.59.1.11.21.21.35.28.13.14.27.26.44.35.03.03.05.06.08.09.45.36.89.73,1.34,1.09.37.29.71.61,1.1.88.01.01.03.02.04.04.23.23.49.42.75.62.1.08.21.17.31.25.17.17.35.31.55.44.13.13.27.25.43.35.11.12.23.22.37.3Z"
                              />
                              <path
                                className="cls-5"
                                d="M39.69,1.57c-.51-.38-1.02-.77-1.53-1.15.04-.06.08-.04.11-.04,2.21,0,4.43,0,6.64,0,.1,0,.17.03.25.09.1.08.19.18.31.24.12.12.25.22.39.32.12.12.25.23.39.32.09.08.18.17.28.24.46.37.89.76,1.37,1.1.28.26.58.5.88.73.04.06.09.1.16.13.2.19.4.36.63.51.09.11.21.2.33.27.17.16.34.31.54.44.48.43.99.83,1.49,1.23-.5.69-1,1.38-1.5,2.07-.22.3-.44.59-.66.88-.07-.04-.13-.09-.2-.13-.14-.12-.29-.24-.45-.33-.1-.1-.2-.19-.33-.24-.27-.23-.56-.43-.86-.63-.26-.21-.52-.41-.8-.59-.07-.08-.15-.14-.25-.18-.19-.17-.4-.32-.62-.45-.33-.25-.66-.5-.99-.74-.48-.35-.95-.73-1.46-1.06-.12-.11-.25-.2-.38-.28-.15-.14-.3-.26-.48-.35-.54-.42-1.09-.83-1.66-1.22-.03-.05-.07-.07-.12-.08-.21-.18-.43-.35-.67-.49-.12-.12-.26-.22-.42-.3-.12-.12-.27-.22-.41-.31Z"
                              />
                            </g>
                            <path
                              className="cls-2"
                              d="M8.04,10.63c0-2.06-1.42-3.85-3.88-3.85S0,8.6,0,10.95s1.82,4.24,4.45,4.24c1.15,0,2.18-.31,2.85-1,.16-.15.15-.28.08-.38l-.75-1.05c-.08-.13-.16-.16-.29-.1-.67.36-1.19.38-1.65.38-.99,0-1.69-.28-1.99-1.01h0c-.1-.33-.15-.68-.15-1.04,0-.29.03-.57.1-.85,0,0,0,0,0,0h0c.21-.82.83-1.13,1.54-1.13s1.26.28,1.42,1.13h-1.86c-.21,0-.37.17-.37.37v1.12c0,.22.18.39.39.39h3.26c.8,0,1.01-.54,1.01-1.41ZM3.37,13.36h0s0,0,0,0h0Z"
                            />
                            <path
                              className="cls-2"
                              d="M25.52,10.63c0-2.06-1.42-3.85-3.88-3.85s-4.16,1.82-4.16,4.17,1.82,4.24,4.45,4.24c1.15,0,2.18-.31,2.85-1,.16-.15.15-.28.08-.38l-.75-1.05c-.08-.13-.16-.16-.29-.1-.67.36-1.19.38-1.65.38-.99,0-1.69-.28-1.99-1.01h0c-.1-.33-.15-.68-.15-1.04,0-.29.03-.57.1-.85,0,0,0,0,0,0h0c.21-.82.83-1.13,1.54-1.13s1.26.28,1.42,1.13h-1.86c-.21,0-.37.17-.37.37v1.12c0,.22.18.39.39.39h3.26c.8,0,1.01-.54,1.01-1.41ZM20.85,13.36h0s0,0,0,0h0Z"
                            />
                            <g>
                              <path
                                className="cls-2"
                                d="M29.43,10.99v-2.79l-.08-.84c0-.21-.11-.28-.25-.28h-2.16c-.15,0-.26.11-.26.26v7.5c0,.15.11.26.26.26h2.23c.15,0,.26-.11.26-.26v-3.85h0Z"
                              />
                              <path
                                className="cls-2"
                                d="M31.73,6.88c-.56,0-1.01.14-1.38.38-.09.06-.14.16-.14.27v1.95c.14-.05.29-.07.46-.07.8,0,1.21.49,1.21,1.49v3.94c0,.14.12.26.26.26h2.21c.15,0,.28-.13.28-.28v-4.62c0-2.08-1.24-3.32-2.9-3.32Z"
                              />
                            </g>
                            <g>
                              <path
                                className="cls-2"
                                d="M40.24,9.19h.62c.15,0,.26-.11.26-.26v-1.59c0-.15-.11-.26-.26-.26h-.62v2.11Z"
                              />
                              <path
                                className="cls-2"
                                d="M40.86,12.92c-.23.02-.36,0-.51,0-.39,0-.69-.23-.69-.62v-7.09c0-.15-.11-.26-.26-.26h-2.26c-.15,0-.26.11-.26.26v1.87h-1c-.15,0-.25.11-.25.26v1.59c0,.15.1.26.25.26h1v3.4c0,2,1.39,2.6,2.75,2.6.59,0,1.51-.11,1.51-.54v-1.51c0-.16-.15-.25-.28-.23Z"
                              />
                            </g>
                            <g>
                              <path
                                className="cls-2"
                                d="M12.77,11.81v.02s-1.63-4.65-1.63-4.65c-.05-.13-.18-.2-.31-.2h-2.28c-.18,0-.28.1-.21.28l2.99,7.54c.05.13.16.20.29.20h2.24s0,0,.01,0l-1.12-3.19Z"
                              />
                              <path
                                className="cls-2"
                                d="M16.96,6.98h-2.26c-.13,0-.28.07-.33.20l-1.36,3.93,1.07,3.05c.06.16.28.17.35,0l2.74-6.90c.07-.18-.03-.28-.21-.28Z"
                              />
                            </g>
                          </g>
                        </g>
                      </svg>
                    </div>
                    <div className="LetterHeadTagline">
                      NE RATEZ PLUS RIEN, LOCALEMENT
                    </div>
                  </div>
                </div>
                <div className="invoice-header">
                  <div className="invoice-header-right">
                    <div className="invoice-header-left">
                      <div className="invoice-title">Facture</div>
                    </div>
                    <div className="invoice-info">
                      <div>{invoiceNumber}</div>
                      <div>Date de création : {creationDate}</div>
                    </div>
                    <div
                      className="invoice-business-info"
                      style={{ marginTop: "25px" }}
                    >
                      <div className="invoice-business-name">
                        {invoiceData?.name}
                      </div>
                      <div className="invoice-business-points">
                        {invoiceData?.organization}
                      </div>
                      <div className="invoice-business-points">
                        {invoiceData.communeName == ""
                          ? ""
                          : invoiceData?.communeName}
                      </div>
                      <div className="invoice-business-points">
                        {invoiceData.address == "" ? "" : invoiceData?.address}
                      </div>
                      {/* <div className="invoice-business-points">
                        {invoiceData.businessCountry || "France"}
                      </div> */}
                    </div>
                  </div>
                </div>
              </div>

              {/* LetterHead Content Area */}
              <div className="LetterHeadContent">
                <div className="invoice-table-container">
                  <div className="invoice-section-title">
                    ONLINE ADVERTISING
                  </div>
                  <table className="invoice-table">
                    <thead>
                      <tr>
                        <th>N°</th>
                        <th>DÉSIGNATION</th>
                        <th>QTÉ</th>
                        <th>PRIX U.</th>
                        <th>TOTAL HT</th>
                      </tr>
                    </thead>
                  </table>

                  <table className="invoice-table">
                    <tbody>
                      {items.map((item: any) => (
                        <React.Fragment key={item.number}>
                          <tr>
                            <td
                              style={{
                                borderBottom: "none",
                                paddingBottom: "0px",
                              }}
                            >
                              {item.number}
                            </td>
                            <td
                              style={{
                                borderBottom: "none",
                                paddingBottom: "0px",
                              }}
                            >
                              <div>
                                <strong>Campaign Title:</strong>{" "}
                                {invoiceData.campaignTitle}
                              </div>
                              <div>
                                <strong>Commune:</strong>{" "}
                                {invoiceData.communeName}
                              </div>
                              {/* <div className="invoice-item-detail">
                                GeoPricing Level :{" "}
                                <span style={{ fontWeight: "bold" }}>
                                  {item.geoPricingLevel}
                                </span>
                                <br />
                                <span style={{ fontWeight: "bold" }}>
                                  Chosen event :
                                </span>
                                <br />
                                {item.eventName} | {item.eventLocation}
                                <br />
                                <span style={{ fontWeight: "bold" }}>
                                  {item.eventDates}
                                </span>
                              </div> */}
                            </td>
                            <td
                              style={{
                                borderBottom: "none",
                                paddingBottom: "0px",
                                paddingTop: "106px",
                              }}
                            >
                              {item.quantity}
                            </td>
                            <td
                              style={{
                                borderBottom: "none",
                                paddingBottom: "0px",
                                paddingTop: "106px",
                              }}
                            >
                              {formatCurrency(invoiceData?.payment?.amount)}
                            </td>
                            <td
                              style={{
                                borderBottom: "none",
                                paddingBottom: "0px",
                                paddingTop: "106px",
                                fontWeight: "bold",
                                color: "#231f20",
                              }}
                            >
                              {formatCurrency(item.total)}
                            </td>
                          </tr>
                          <tr>
                            <td
                              style={{
                                borderBottom: "none",
                                paddingTop: "6px",
                                paddingBottom: "0px",
                              }}
                            ></td>
                            <td
                              style={{
                                borderTop: "1px solid #e0e0e0",
                                paddingTop: "6px",
                                borderBottom: "none",
                                paddingBottom: "0px",
                              }}
                            >
                              {/* <div className="invoice-coupon-text">
                                Free random events
                              </div> */}
                            </td>
                            <td
                              style={{
                                borderTop: "1px solid #e0e0e0",
                                borderBottom: "none",
                                paddingTop: "6px",
                                paddingBottom: "0px",
                              }}
                            >
                              {/* 3 */}
                            </td>
                            <td
                              style={{
                                borderTop: "1px solid #e0e0e0",
                                borderBottom: "none",
                                paddingTop: "6px",
                                paddingBottom: "0px",
                              }}
                            >
                              {/* 0,00 € */}
                            </td>
                            <td
                              style={{
                                borderTop: "1px solid #e0e0e0",
                                borderBottom: "none",
                                paddingTop: "6px",
                                paddingBottom: "0px",
                                fontWeight: "bold",
                                color: "#231f20",
                              }}
                            >
                              {/* 0,00 € */}
                            </td>
                          </tr>
                          <tr className="invoice-net-ht-row">
                            <td></td>
                            <td></td>
                            <td></td>
                            <td
                              style={{
                                backgroundColor: "#bce5f2",
                                paddingBottom: "2px",
                                paddingTop: "7px",
                                width: "75px",
                                fontWeight: "bold",
                                color: "#231f20",
                              }}
                            >
                              NET HT
                            </td>
                            <td
                              style={{
                                backgroundColor: "#bce5f2",
                                paddingBottom: "2px",
                                paddingTop: "7px",
                                width: "75px",
                                fontWeight: "bold",
                                color: "#231f20",
                              }}
                            >
                              {formatCurrency(invoiceData?.payment?.amount)}
                            </td>
                          </tr>
                        </React.Fragment>
                      ))}
                    </tbody>
                  </table>
                </div>

                <div className="invoice-totals-section">
                  <div
                    style={{
                      borderTop: "1px solid black",
                      width: "300px",
                      padding: "6px 15px",
                    }}
                  ></div>
                  <div className="invoice-total-row invoice-total-net-ht">
                    <div className="invoice-total-label">TOTAL NET HT</div>
                    <div className="invoice-total-amount">
                      {formatCurrency(totalHT)}
                    </div>
                  </div>

                  <div className="invoice-total-row invoice-vat-row">
                    <div className="invoice-total-label">DISCOUNT</div>
                    <div
                      className="invoice-total-amount"
                      style={{ fontWeight: "bold", color: "#231f20" }}
                    >
                      -{invoiceData?.payment.discount}
                    </div>
                  </div>
                  <div className="invoice-total-row invoice-total-ttc">
                    <div className="invoice-total-label">TOTAL TTC</div>
                    <div className="invoice-total-amount">
                      {formatCurrency(invoiceData?.payment?.final_amount)}
                    </div>
                  </div>
                </div>
              </div>

              {/* LetterHead Footer */}
              <div className="LetterHeadFooter">
                <div className="LetterHeadFooterInfo">
                  <div>
                    {/* Footer content */}
                    <div className="LetterHeadFooterItem">
                      <div className="LetterHeadFooterTextContainer">
                        <div className="LetterHeadFooterText">eventx.fr</div>
                        <div className="LetterHeadFooterText">
                          <a
                            href="mailto:infos@eventx.fr"
                            style={{ textDecoration: "none", color: "gray" }}
                          >
                            infos@eventx.fr
                          </a>
                        </div>
                      </div>
                      <div className="LetterHeadFooterIconBox">
                        <svg
                          className="LetterHeadFooterIcon"
                          viewBox="0 0 24 24"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M20 4H4C2.9 4 2 4.9 2 6V18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 8L12 13L4 8V6L12 11L20 6V8Z"
                            fill="currentColor"
                          />
                        </svg>
                      </div>
                    </div>
                    {/* LetterHead Address */}
                    <div className="LetterHeadFooterItem">
                      <div className="LetterHeadFooterTextContainer">
                        <div className="LetterHeadFooterText">
                          1 place de la République
                        </div>
                        <div className="LetterHeadFooterText">
                          11800 SAINT FRICHOUX
                        </div>
                      </div>
                      <div className="LetterHeadFooterIconBox">
                        <svg
                          className="LetterHeadFooterIcon"
                          viewBox="0 0 24 24"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M10 20V14H14V20H19V12H22L12 3L2 12H5V20H10Z"
                            fill="currentColor"
                          />
                        </svg>
                      </div>
                    </div>
                    <div className="LetterHeadFooterItem">
                      <div className="LetterHeadFooterTextContainer">
                        <div className="LetterHeadFooterText">
                          <span className="LetterHeadFooterLabel">SIREN :</span>
                        </div>
                        <div className="LetterHeadFooterText">
                          <span className="LetterHeadFooterLabel">APE :</span>
                        </div>
                      </div>
                      <div className="LetterHeadFooterIconBox">
                        <svg
                          className="LetterHeadFooterIcon"
                          viewBox="0 0 24 24"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <circle
                            cx="12"
                            cy="12"
                            r="9"
                            stroke="currentColor"
                            strokeWidth="2"
                            fill="none"
                          />
                          <path
                            d="M12 6V12L16 14"
                            stroke="currentColor"
                            strokeWidth="2"
                            strokeLinecap="round"
                          />
                        </svg>
                      </div>
                    </div>
                    {/* Add other footer items */}
                  </div>
                </div>
                {/* Color strip */}
                <div className="LetterHeadColorStrip">
                  <div className="LetterHeadColorBlock LetterHeadColorCyan"></div>
                  <div className="LetterHeadColorBlock LetterHeadColorRed"></div>
                  <div className="LetterHeadColorBlock LetterHeadColorNavy"></div>
                  <div className="LetterHeadColorBlock LetterHeadColorLightBlue"></div>
                  <div className="LetterHeadColorBlock LetterHeadColorDarkRed"></div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <button
          className="close-price-selector-btn"
          onClick={onClose}
          style={{ position: "absolute", top: "10px", right: "10px" }}
        >
          ×
        </button>
      </div>
    </div>
  );
};

// Helper functions
const formatDate = (dateString: string): string => {
  const date = new Date(dateString);
  const day = date.getDate().toString().padStart(2, "0");
  const month = (date.getMonth() + 1).toString().padStart(2, "0");
  const year = date.getFullYear();
  return `${day}/${month}/${year}`;
};

const formatCurrency = (amount: any): string => {
  const numericAmount =
    typeof amount === "number"
      ? amount
      : typeof amount === "string"
      ? parseFloat(amount) || 0
      : 0;

  return `${numericAmount.toFixed(2).replace(".", ",")} €`;
};

const createInvoiceItemsFromAdverts = (data: any): any[] => {
  if (!data.adverts || data.adverts.length === 0) {
    return [getDefaultInvoiceItem(data)];
  }

  return data.adverts.map((advert: any, index: number) => {
    const paidDays =
      advert.paidDays || calculatePaidDays(advert.startDate, advert.endDate);
    const pricePerDay = parseFloat(
      advert.price_per_day || advert.recorded_geo_price_per_day || "0"
    );
    const totalHT = pricePerDay * paidDays;

    return {
      number: index + 1,
      description: `Publicité ${data.advertType || "Large"} - ${
        advert.eventTitle || "Événement"
      }`,
      geoPricingLevel: advert.geo_price_level || "",
      eventName: advert.eventTitle || advert.eventNo || "Événement sans nom",
      eventLocation: "En ligne",
      eventDates: formatEventDates(advert.startDate, advert.endDate),
      quantity: paidDays,
      unitPrice: pricePerDay,
      total: totalHT,
    };
  });
};

const formatEventDates = (startDate: string, endDate: string): string => {
  const start = new Date(startDate);
  const end = new Date(endDate);
  const monthNames = [
    "janv",
    "févr",
    "mars",
    "avr",
    "mai",
    "juin",
    "juil",
    "août",
    "sept",
    "oct",
    "nov",
    "déc",
  ];
  const startDay = start.getDate();
  const endDay = end.getDate();
  const month = monthNames[start.getMonth()];
  const year = start.getFullYear();
  return `${startDay} - ${endDay} ${month} ${year}`;
};

const getDefaultInvoiceItem = (data: any): any => {
  const paidDays = 1;
  const totalAmount = parseFloat(data.totalAmount || "0");
  return {
    number: 1,
    description: `Campagne publicitaire - ${
      data.campaignTitle || "Sans titre"
    }`,
    geoPricingLevel: "Standard",
    eventName: "Événement multiple",
    eventLocation: "En ligne",
    eventDates: "Durée variable",
    quantity: paidDays,
    unitPrice: totalAmount,
    total: totalAmount,
  };
};

const calculatePaidDays = (startDate: string, endDate: string): number => {
  const start = new Date(startDate);
  const end = new Date(endDate);
  const diffTime = Math.abs(end.getTime() - start.getTime());
  const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
  return diffDays + 1;
};

export default InvoiceModal;
