"use client";

import { useState } from "react";
import "./FAQ.css";

interface FAQItem {
  id: number;
  question: string;
  answer: string;
}

export default function FAQ() {
  const [activeId, setActiveId] = useState<number | null>(null);

  const faqData: FAQItem[] = [
    {
      id: 1,
      question: "Comment se déroule la période de test bêta ?",
      answer:
        "Pendant la période bêta, notre équipe surveille constamment le site pour détecter et corriger les erreurs. Nous vous remercions pour votre patience durant cette phase de lancement. Vos retours sont précieux — n'hésitez pas à nous envoyer vos suggestions pour améliorer nos portails et notre service.",
    },
    {
      id: 2,
      question: "Quelle est la période d'essai gratuite ?",
      answer:
        "La période d'essai spéciale se déroule du 27 novembre au 7 décembre 2025 inclus. Pendant cette période, vous pouvez tester toutes les fonctionnalités de notre portail publicitaire sans engagement.",
    },
    {
      id: 3,
      question: "Comment fonctionne le crédit gratuit de 100€ ?",
      answer:
        "Chaque nouveau compte reçoit un portefeuille virtuel crédité de 100€ pour découvrir notre système publicitaire. Le coût de vos annonces est automatiquement déduit de ce solde. Vous pouvez suivre votre consommation en temps réel dans votre espace personnel.",
    },
    {
      id: 4,
      question: "Que se passe-t-il avec mon solde après le 7 décembre 2025 ?",
      answer:
        "Après le 7 décembre 2025, tous les soldes des portefeuilles seront remis à zéro et notre tarification standard géolocalisée s'appliquera. Des rappels vous seront envoyés avant l’échéance.",
    },
    {
      id: 5,
      question:
        "Puis-je acheter un espace publicitaire au-delà du 7 décembre ?",
      answer:
        "Oui ! Vous pouvez acheter des emplacements publicitaires qui continuent après la période d'essai. Seule la partie de votre publicité apparaissant après le 7 décembre 2025 sera facturée au tarif standard.",
    },
    {
      id: 6,
      question:
        'Quelle est la différence entre un "Événement" et une "Activité" ?',
      answer:
        "Un Événement est une manifestation locale, souvent gratuite ou très accessible, destinée à animer une commune ou un quartier (ex : marché de Noël, concert dans un bar). Une Activité est une prestation commerciale nécessitant l'achat d'un billet ou forfait (ex : concert d’un artiste international, rafting).",
    },
    {
      id: 7,
      question: "Mon initiative est-elle un Événement ou une Activité ?",
      answer:
        "- Si l’on peut y participer librement ou à faible coût, c’est un Événement.\n- Si l’accès nécessite un billet onéreux, c’est une Activité.\nEn cas de doute, notre équipe support peut vous aider.",
    },
    {
      id: 8,
      question: "Comment publier une annonce sur votre site ?",
      answer:
        "Utilisez notre portail en libre-service ! Ajoutez vos informations, photos et détails en quelques minutes. Aucune intervention humaine n’est nécessaire pour la mise en ligne.",
    },
    {
      id: 9,
      question:
        "Sur quelles pages ma publication peut-elle apparaître et quels formats sont acceptés ?",
      answer:
        "Vous pouvez apparaître sur :\n- SEP (Page Événement Unique)\n- Page CityHub\n- Page Catégorie\nFormats acceptés : images (JPEG, PNG), texte enrichi, vidéos. Les tailles exactes sont automatiquement proposées selon l’emplacement.",
    },
    {
      id: 10,
      question:
        "Puis-je modifier ou supprimer ma publication après mise en ligne ?",
      answer:
        "Oui ! Vous pouvez modifier ou supprimer votre contenu à tout moment depuis votre espace personnel. Les modifications sont instantanées.",
    },
    {
      id: 11,
      question: "Puis-je mettre en pause ma publication ?",
      answer:
        "Oui ! Vous pouvez mettre en pause et réactiver votre annonce quand vous le souhaitez, sans perte des informations ni de l'historique.",
    },
    {
      id: 12,
      question: "Comment fonctionne la tarification géographique ?",
      answer:
        "La tarification s'adapte automatiquement à votre localisation pour garantir un prix équitable basé sur le pouvoir d’achat de votre région.",
    },
    {
      id: 13,
      question:
        "Pourquoi les prix varient-ils selon les départements et communes ?",
      answer:
        "Pour assurer une équité d'accès pour tous les organisateurs, quel que soit leur lieu. Cela encourage une diversité d’événements dans tout le pays.",
    },
    {
      id: 14,
      question: "Y a-t-il des frais cachés ?",
      answer:
        "Non ! Le prix final est affiché clairement avant toute validation. Aucun frais supplémentaire n’est ajouté.",
    },
    {
      id: 15,
      question: "Dois-je fournir une carte bancaire pour la période bêta ?",
      answer:
        "Non ! La période bêta est entièrement gratuite et aucune carte bancaire n’est requise pour utiliser le crédit de 100€ offert.",
    },
    {
      id: 16,
      question: "Quels types d'événements puis-je publier ?",
      answer:
        "Tous les événements légaux : culturels, sportifs, gastronomiques, associatifs, professionnels, etc. Ils doivent respecter nos conditions d'utilisation.",
    },
    {
      id: 17,
      question: "Quels contenus sont interdits ?",
      answer:
        "Tout contenu illégal, discriminatoire, pornographique ou contraire aux bonnes mœurs est strictement interdit.",
    },
    {
      id: 18,
      question: "Puis-je promouvoir des événements payants ?",
      answer:
        "Oui ! Vous pouvez promouvoir des événements nécessitant un billet, des activités commerciales ou des événements gratuits.",
    },
    {
      id: 19,
      question: "Où mon événement sera-t-il visible ?",
      answer:
        "Sur notre site web, applications mobiles, newsletters et réseaux sociaux. Une visibilité multi-canal est garantie.",
    },
    {
      id: 20,
      question:
        "Combien de temps faut-il pour que mon événement soit en ligne ?",
      answer:
        "Immédiatement ! Dès la validation dans le portail, votre événement est visible par toute notre communauté.",
    },
    {
      id: 21,
      question: "Qui contacter en cas de problème technique ?",
      answer:
        "Vous pouvez contacter notre équipe support par email à support@votresite.com ou via le chat du portail. Réponse sous 24h.",
    },
    {
      id: 22,
      question: "Le portail est-il compatible mobile ?",
      answer:
        "Oui ! Le portail est 100% responsive et fonctionne parfaitement sur smartphones, tablettes et ordinateurs.",
    },
  ];

  const toggleFAQ = (id: number) => {
    setActiveId(activeId === id ? null : id);
  };

  return (
    <div id="faq" className="advertFaq-container">
      <h1>Foire aux questions</h1>

      {faqData.map((item) => (
        <div
          key={item.id}
          className={`advertFaq-item ${
            activeId === item.id ? "advertFaq-active" : ""
          }`}
        >
          <div
            className="advertFaq-question"
            onClick={() => toggleFAQ(item.id)}
          >
            <h3>{item.question}</h3>
            <div className="advertFaq-icon">
              <img src="/advert-info/Asset arrow.svg" alt="" />
            </div>
          </div>
          <div className="advertFaq-answer">
            <p>{item.answer}</p>
          </div>
        </div>
      ))}
    </div>
  );
}
