// app/profile/page.jsx
"use client";
import { useEffect } from "react";
import { useRouter, usePathname } from "next/navigation";
import "./ProfileSection.css";
import { useAppDispatch, useAppSelector } from "../../hooks/useDispatch";
import { fetchUserWallets } from "@/app/redux/services/main/campaigns/mycampaign";
import { useSettingsData } from "@/app/hooks/useData";
import { getUserInfo } from "@/app/utils/token";
export default function ProfilesSection() {
  const router = useRouter();
  const pathname = usePathname();
  const dispatch = useAppDispatch();
  const { data: translations } = useSettingsData();
  const t = translations || {};
  const { wallet } = useAppSelector((state) => state.auth);
  const userInfo = getUserInfo();
  const userName =
    userInfo?.name || userInfo?.username || userInfo?.email || "U";
  const firstLetter = userName.charAt(0).toUpperCase();
  const userPhoto = userInfo?.photo
    ? `https://admin.eventx.fr/uploads/users/${userInfo.photo}`
    : null;
  useEffect(() => {
    const fetchWalletData = async () => {
      try {
        await dispatch(fetchUserWallets()).unwrap();
      } catch (error) {
        console.error("Failed to fetch wallet data:", error);
      }
    };

    fetchWalletData();
  }, [dispatch]);

  const getWalletBalance = (): string => {
    if (!wallet) return "0,00";
    const balance = parseFloat(wallet.balance) || 0;

    return new Intl.NumberFormat("fr-FR", {
      minimumFractionDigits: 2,
      maximumFractionDigits: 2,
    }).format(balance);
  };

  return (
    <div className="profile-container">
      <div className="page-name-home">{t.profile?.pageName || "Home"}</div>
      <div className=" ProfileSectionMain ">
        {/* Header Section */}
        <div className="profile-header">
          <div className="user-info">
            <div className="avatar">
              {userPhoto ? (
                <img
                  src={userPhoto}
                  alt={`${userName}'s profile`}
                  className="w-25 h-25 rounded-full object-cover "
                  onError={(e) => {
                    e.currentTarget.style.display = "none";
                  }}
                />
              ) : (
                <div className="w-10 h-10 bg-[#0071bc] rounded-full flex items-center justify-center text-white font-semibold text-lg">
                  {firstLetter}
                </div>
              )}
              {/* <button className="avatar-plus">+</button> */}
            </div>
            {/* <div className="username">Haider</div> */}
          </div>
          <div className="modify">{/* Modifier */}</div>
        </div>

        {/* Wallet Section */}
        <div className="wallet-card">
          <div className="wallet-icon">
            <div className="wallet-icon-inner"></div>
          </div>
          <div className="wallet-info">
            <div className="wallet-title">
              {t.profile?.wallet?.title || "Wallet"}
            </div>
            <div className="wallet-balance">{getWalletBalance()} €</div>
            <div className="wallet-subtitle">
              {t.profile?.wallet?.balanceAvailable || "Balance available"}
            </div>
            <button className="add-funds-button">
              {t.profile?.wallet?.addFunds || "+ Add funds"}
            </button>
          </div>
        </div>
      </div>
      {/* Action Cards */}
      <div className="ActionCardsContent">
        <div className="action-cards">
          {/* Settings Card */}
          <div className=" settings-card">
            <div className="action-card-copymain">
              <div className="cardicon-cardtittle ">
                <div className="card-icon">
                  <img src="/images/Asset 24.svg" alt="" />
                </div>
                <div className="card-title">
                  {t.profile?.settings?.title || "Settings"}
                </div>
              </div>
              <div className="card-description">
                {t.profile?.settings?.description ||
                  "Mettre à jour mes informations personnelles et mes préférences"}
              </div>
            </div>{" "}
          </div>

          {/* Subscriptions Card */}
          <div className="action-card subscriptions-card">
            <div className="cardicon-cardtittle ">
              <div className="card-icon">
                <img src="/images/Asset 27.svg" alt="" />
              </div>
              <div className="card-title">
                {t.profile?.subscriptions?.title || "Subscriptions"}
              </div>
            </div>
            <div className="card-description">
              {t.profile?.subscriptions?.description ||
                "Cliquez ici pour voir votre niveau d'abonnement et les avantages associés"}
            </div>
          </div>

          {/* Help Card */}
          <div
            className="action-card help-card"
            onClick={() => {
              const handleNavigation = () => {
                const faqElement = document.getElementById("faq");
                if (faqElement) {
                  faqElement.scrollIntoView({ behavior: "smooth" });
                }
              };

              if (pathname === "/") {
                // Already on home page, just scroll
                handleNavigation();
              } else {
                // Navigate to home page with hash
                router.push("/#faq");
                // Scroll after navigation completes
                setTimeout(handleNavigation, 300);
              }
            }}
            style={{ cursor: "pointer" }}
          >
            <div className="cardicon-cardtittle ">
              <div className="card-icon ">
                <img src="/images/Asset 28.svg" alt="" />
                {/* <span>?</span> */}
              </div>
              <div className="card-title">
                {t.profile?.help?.title || "Help"}
              </div>
            </div>
            <div className="card-description">
              {t.profile?.help?.description ||
                "Accédez à la FAQ et aux options de contact"}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
