// app/redux/features/main/campaignSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import {
  fetchUserCampaigns,
  deleteUserCampaign,
} from "@/app/redux/services/main/campaigns/mycampaign";
export interface Campaign {
  media_type: string;
  advert_type: string;
  advert_redirect_url?: string;
  location: string;
  startDate: string;
  endDate: string;
  price: number;
  commune: string;
  postcode: string;
  coupon_code: string;
  format: string;
  title: string;
  event_id: string;
  user_notes: string;
  duration: number;
  image: string;
  totalprice: string;
}

interface CampaignState {
  userCampaigns: any[];
  userCampaignsLoading: boolean;
  userCampaignsError: string | null;
}

const initialState: CampaignState = {
  userCampaigns: [],
  userCampaignsLoading: false,
  userCampaignsError: null,
};

export const campaignSlice = createSlice({
  name: "advertcampaign",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      // Fetch User Campaigns
      .addCase(fetchUserCampaigns.pending, (state) => {
        state.userCampaignsLoading = true;
        state.userCampaignsError = null;
      })
      .addCase(fetchUserCampaigns.fulfilled, (state, action) => {
        state.userCampaignsLoading = false;
        state.userCampaigns = action.payload.data;
        state.userCampaignsError = null;
      })
      .addCase(fetchUserCampaigns.rejected, (state, action) => {
        state.userCampaignsLoading = false;
        state.userCampaignsError = action.payload as string;
        state.userCampaigns = [];
      })
      .addCase(deleteUserCampaign.pending, (state) => {
        // state.userCampaignsLoading = true;
      })
        .addCase(deleteUserCampaign.fulfilled, (state, action) => {
        state.userCampaigns = state.userCampaigns.filter(
          (campaign) => campaign.id !== action.payload.campaignId
        );
      })
      .addCase(deleteUserCampaign.rejected, (state, action) => {
        // state.userCampaignsLoading = false;
        state.userCampaignsError = action.payload as string;
      });
  },
});

export const {} = campaignSlice.actions;

export default campaignSlice.reducer;
