
import {LocationSearchResponse} from "@/app/types"
import { createAsyncThunk } from '@reduxjs/toolkit';
export const searchLocations = async (
  searchKeyword: string
): Promise<LocationSearchResponse> => {
  try {
    if (!searchKeyword.trim()) {
      return {
        status: 200,
        getResult: []
      };
    }
    const response = await fetch(
      `https://admin.eventx.fr/api/get-state-with-country?search_keyword=${encodeURIComponent(searchKeyword)}`
    );

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data: LocationSearchResponse = await response.json();
    return data;
  } catch (error) {
    console.error('Error searching locations:', error);
    throw new Error(
      error instanceof Error 
        ? error.message 
        : 'Failed to fetch locations'
    );
  }
};


export const fetchGeoPricingLocations = createAsyncThunk(
  'campaign/fetchGeoPricingLocations',
  async (_, { rejectWithValue }) => {
    try {
      const response = await fetch(
        `${process.env.NEXT_PUBLIC_API_URL_New}/geo-pricing`
      );

      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }

      const data: any = await response.json();
      return data;
    } catch (error: any) {
      const errorMessage = error instanceof Error 
        ? error.message 
        : 'Failed to fetch geo-pricing locations';
      return rejectWithValue(errorMessage);
    }
  }
);