import { configureStore, ThunkAction, Action } from "@reduxjs/toolkit";
import eventAuthReducer from "./features/auth/authAction";
import advertActionReducer from "./features/main/campaigns/advertAction";
import compaignActionReducer from "./features/main/campaigns/campaignAction";
import eventHubActionReducer from "./features/main/campaigns/eventHubAction";
import categoryReducer from "./features/main/campaigns/categoryAction"
export const store = configureStore({
  reducer: {
    auth: eventAuthReducer,
    compaign:advertActionReducer,
    advertcompaign:compaignActionReducer,
    eventhub:eventHubActionReducer,
    category:categoryReducer
  },
});

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
export type AppThunk<ReturnType = void> = ThunkAction<
  ReturnType,
  RootState,
  unknown,
  Action<string>
>;
