"use client";
import React, { useEffect, useState } from "react";
import Link from "next/link";
import Image from "next/image";
import { usePathname } from "next/navigation";
import "./footer.css";
// import { signOut, useSession } from "next-auth/react";
import { ChangeEvent } from "react";
import Script from "next/script";
export default function FooterNew() {
  // const { data: session } = useSession();
  // const user = session?.user;

  const currentRoute = usePathname();
  const [footerPadding, setFooterPadding] = useState(false);
  const [formValues, setFormValues] = useState({
    email: "",
  });
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);
  const [isModalOpen, setIsModalOpen] = useState(false);

  useEffect(() => {
    if (currentRoute == "/") {
      setFooterPadding(true);
    } else {
      setFooterPadding(false);
    }
  }, [currentRoute]);
  const [showFooter, setShowFooter] = useState(false);
  const handleChange = (event: ChangeEvent<HTMLInputElement>) => {
    const { name, value } = event.target;
    setFormValues({ ...formValues, [name]: value });
  };

  const openModal = () => {
    setIsModalOpen(true);
  };

  const closeModal = () => {
    setIsModalOpen(false);
    setSuccess(false);
    window.location.reload();
  };
  useEffect(() => {
    const timeoutId = setTimeout(() => {
      setShowFooter(true);
    }, 3000);

    return () => {
      clearTimeout(timeoutId);
    };
  }, []);

  return (
    <>
      {/* {showFooter && <CookiesComponent dir={dir} />} */}
      <section className="footer-section-with-bg">
        {/* Centered blue container */}
        <div className="centered-blue-container">
          <Image
            src="/footer/footerAsset3.png" // Update with your image path
            alt="Centered Logo"
            width={110}
            // width={220}
            // Adjust as needed
            height={110}
            className="centered-image"
            style={{
              position: "absolute",
              top: "99%",
              left: "50%",
              transform: "translate(-50%, -50%)",
            }}
          />
          <div className="content-wrapper">
            {/* First row */}
            <div className="first-row">
              <span>Pour toute l’actualité </span>
            </div>

            {/* Second row */}
            <div className="second-row">
              <div className="left-item">
                <span>
                  Inscrivez-vous à notre newsletter
                  <br />
                </span>
              </div>
              <div className="button-sub-right">
                <button className="subscribe-button" onClick={openModal}>
                  S'inscrire
                </button>
              </div>
            </div>
          </div>
        </div>
        <div className="footer-columns-container">
          {/* First two columns grouped together */}
          <div className="footer-columns-group">
            <div className="footer-column">
              <h4 className="column-header">Navigation</h4>
              <ul className="footer-list">
                <li className="footer-item">
                  <Link
                    href="https://eventx.fr/events"
                    style={{ color: "white" }}
                  >
                    Rechercher des événements
                  </Link>
                </li>
                <li className="footer-item">
                  <Link
                    href="https://eventx.fr/login"
                    style={{ color: "white" }}
                  >
                    {" "}
                    Connexion Utilisateur
                  </Link>
                </li>
              </ul>
            </div>

            <div className="footer-column">
              <h4 className="column-header-other">Assistance</h4>
              <ul className="footer-list-other">
                <li className="footer-item">
                  <Link
                    href="https://eventx.fr/cookies"
                    style={{ color: "white" }}
                  >
                    Politique relative aux cookies
                  </Link>
                </li>
                <li className="footer-item">
                  <Link
                    href="https://eventx.fr/cookies"
                    style={{ color: "white", whiteSpace: "nowrap" }}
                  >
                    Mentions Légales
                  </Link>
                </li>
                {/* <li className="footer-item-disable">
           
              {dir.footer.RGPD}
            </li> */}
                {/* <li className="footer-item-disable">
              {dir.footer.Plandusite}
           </li> */}
                <li className="footer-item mobile-footer-item-faq">
                  <Link href="https://eventx.fr/faq" style={{ color: "white" }}>
                    FAQ
                  </Link>
                </li>
                <li className="footer-item mobile-footer-item-contact">
                  <Link
                    href="https://eventx.fr/contact"
                    style={{ color: "white" }}
                  >
                    Contact
                  </Link>
                </li>
                <li className="footer-item mobile-footer-item-conditions">
                  <Link
                    href="https://eventx.fr/use-of-the-site"
                    style={{ color: "white" }}
                  >
                    Conditions générales
                  </Link>
                </li>
              </ul>
            </div>
          </div>

          {/* Third column with more spacing */}
          <div className="footer-column-last">
            <div className="app-store-container">
              <div style={{ display: "flex", justifyContent: "center" }}>
                <h4 className="column-header-last">Apps et réseaux sociaux</h4>
              </div>
              <Link
                href="https://play.google.com/store/apps/details?id=com.alikhanhaider021.eventx&pli=1"
                target="_blank"
                rel="noopener noreferrer"
              >
                <Image
                  src="/footer/footerAsset4.png" // Google Play
                  alt="Google Play Store"
                  width={160} // 77.426mm ≈ 292.63px
                  height={87} // 23.063mm ≈ 87.17px
                  className="app-store-image"
                />
              </Link>
              <Link
                href="https://apps.apple.com/fr/app/eventx-%C3%A9v%C3%A9nements-locaux/id6605922775"
                target="_blank"
                rel="noopener noreferrer"
              >
                <Image
                  src="/footer/footerAsset6.png" // Apple App Store
                  alt="Apple App Store"
                  width={160} // Maintains aspect ratio with 87px height
                  height={87} // 23.063mm ≈ 87.17px
                  className="app-apple-store-image"
                />
              </Link>
              <Link
                href="https://www.facebook.com/groups/230192346581187"
                target="_blank"
                rel="noopener noreferrer"
              >
                <Image
                  src="/footer/facebook.png" // Update with your image path
                  alt="Social Media"
                  width={50} // Adjust as needed
                  height={15}
                  className="social-media-image"
                  // style={{ marginTop: "16px" }}
                  style={{ marginTop: "42px" }}
                />
                {/* <Image
                  src="/footer/facebook.png" // Update with your image path
                  alt="Social Media"
                  width={160} // Adjust as needed
                  height={50}
                  className="social-media-image"
                  style={{ marginTop: "16px" }}
                /> */}
              </Link>
            </div>
            {/*  */}
            <div className="social-media-container">
              {/* <Link
                href="https://www.facebook.com/groups/230192346581187"
                target="_blank"
                rel="noopener noreferrer"
              >
                <Image
                  src="/footer/facebook.png" // Update with your image path
                  alt="Social Media"
                  width={160} // Adjust as needed
                  height={50}
                  className="social-media-image"
                />
              </Link> */}
            </div>
            {/*  */}
          </div>
        </div>
      </section>
      {isModalOpen && (
        <div className="modal-overlay" onClick={closeModal}>
          <div className="modal-content" onClick={(e) => e.stopPropagation()}>
            <button className="modal-close" onClick={closeModal}>
              &times;
            </button>

            <div className="row footer">
              <div className="col-lg-12 col-md-12 col-sm-12">
                {success && (
                  <div
                    className="alert alert-success alert-dismissible"
                    style={{
                      background: "#B4E2EE",
                      color: "#000",
                      display: "inline-block",
                    }}
                  >
                    {/* {dir.local_lng.selected_lng === "fr" */}
                    {/* ?  */}
                    ROCHAINEMENT ! Obtenez une liste d'événements
                    {/* : "COMING SHORTLY!"} */}
                    <br />
                    {/* {dir.local_lng.selected_lng === "fr" */}
                    {/* ?  */}
                    proches de chez vous selon votre choix de catégorie
                    {/* : "We'll send you a list of events each month that are happening on your doorstep"} */}
                  </div>
                )}

                <div className="row">
                  <div className="col-md-12 col-sm-12 col-xs-12 mt-2">
                    <Script src="/scripts/ml.js" />
                    <div className="ml-embedded" data-form="nD5NAH"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      )}
      <div className="footer-bottom-container">
        <span>EventX France 2025 v1.9</span>
      </div>
    </>
  );
}
