import React, { useEffect, useState } from "react";
// import { useRouter } from "next/navigation"; 
import { usePathname } from "next/navigation";
import Link from "next/link";

interface SideItemProps {
  to: string;
  icon: string;
  text: string;
  onClick?: () => void;
    disabled?: boolean;
}

const SideItem: React.FC<SideItemProps> = ({ to, icon, text, onClick,disabled = false  }) => {
  const [mounted, setMounted] = useState(false);
  // const router = useRouter();
  const pathname = usePathname(); 

  useEffect(() => {
    setMounted(true); 
  }, []);

  if (!mounted) return null;

 const handleClick = (e: React.MouseEvent) => {
    if (disabled) {
      e.preventDefault(); // Prevent navigation if disabled
      return;
    }
    if (onClick) {
      onClick();
    }
  };
    if (disabled) {
    return (
      <div className={`cursor-not-allowed opacity-70 ${
        pathname === to ? "rounded-md bg-[#6931F7] penta-para" : ""
      } mb-4`}>
        <div className="w-full rounded-md h penta-para">
          <div>
            <div>
              <span
                style={{ fontSize: "1.2rem" }}
                className={`flex justify-center ${
                  pathname === to ? "rounded-full p-4 bg-[#4825B7]" : ""
                }`}
              >
                <img className="w-8" src={icon} alt={text} />
              </span>
            </div>
            <div className="flex justify-center penta-para">
              <span
                className={`penta-para ${pathname === to ? "penta-para" : ""}`}
              >
                {text}
              </span>
            </div>
          </div>
        </div>
      </div>
    );
  }
  return (
    <div
      className={`${
        pathname === to ? "rounded-md bg-[#6931F7] penta-para" : ""
      } mb-4`}
    >
      <div>
        <Link 
          href={to} 
          className="w-full rounded-md h penta-para" 
          onClick={handleClick}
        >
          <div>
            <div>
              <span
                style={{ fontSize: "1.2rem" }}
                className={`flex justify-center ${
                  pathname === to ? "rounded-full p-4 bg-[#4825B7]" : ""
                }`}
              >
                <img className="w-8" src={icon} alt={text} />
              </span>
            </div>
            <div className="flex justify-center penta-para">
              <span
                className={`penta-para ${pathname === to ? "penta-para" : ""}`}
              >
                {text}
              </span>
            </div>
          </div>
        </Link>
      </div>
    </div>
  );
};

export default SideItem;