import type { Metadata } from "next";
import ReduxProvider from "./redux/provider/redux-provider";
import "./globals.css";
import Script from "next/script";
export const metadata: Metadata = {
  title: "Self Serve Portal",
  description: "Self Serve Portal",
  icons: {
    icon: "..//favicon.ico",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <head>
        {/* <Script
          strategy="afterInteractive"
          src="https://www.googletagmanager.com/gtag/js?id=G-GJ82XN9WE5"
        />
        <Script
          id="gtag-init"
          strategy="afterInteractive"
          dangerouslySetInnerHTML={{
            __html: `
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-GJ82XN9WE5', {
        page_path: window.location.pathname,
      });
    `,
          }}
        /> */}
      </head>
      <body className="">
        <ReduxProvider>{children}</ReduxProvider>
      </body>
    </html>
  );
}
