import "./PricingSection.css";
import Image from "next/image";
import Link from "next/link";

export default function PricingSection() {
  return (
    <>
      <div className="PricingSection-container" id="pricing-section">
        {/* Header Section */}
        <div className="PricingSection-header-section">
          <div className="PricingSection-main-heading">Choisis ta formule</div>
          <div className="PricingSection-sub-heading">
            on s'occupe du reste...
          </div>
          <p className="PricingSection-description">
            🎯 Notre site travaille sur le principe équitable. Vous payez en
            fonction de la visibilité réelle. <br />
            Petite commune = petit prix | Grande ville = plus de visibilité =
            prix adapté
          </p>
        </div>

        {/* First Row - Card 1 */}
        <div className="PricingSection-pricing-row">
          <div className="PricingSection-card-wrapper">
            <div className="PricingSection-step-number">1</div>
            <div className="PricingSection-badge PricingSection-badge-gratuit">
              GRATUIT
            </div>

            <div className="PricingSection-pricing-card">
              <div className="PricingSection-card-content">
                <div className="PricingSection-icon-wrapper">
                  <img
                    src="/advert-info/calendar_icon_advert_page.png"
                    className="PricingSection-calendar-icon"
                    alt=""
                  />
                </div>

                <h3 className="PricingSection-card-title">
                  Événement à venir ?
                </h3>
              </div>
            </div>
          </div>

          <div className="PricingSection-text-content">
            <div className=" card1pricing-content ">
              <div className="two-left-para-lines">
                <div className="PricingSection-side-text">
                  T'as un événement à promouvoir ?
                </div>
                <div className="PricingSection-side-text">
                  Dépose-le ici, c'est offert !
                </div>
              </div>
              <div className="PARTI-card1-btn ">
                <Link
                  href="https://www.eventx.fr/dashboard/add_event_default"
                  className="PricingSection-btn PricingSection-btn-primary"
                >
                  C'EST PARTI !
                </Link>
              </div>
            </div>
          </div>
        </div>
      </div>
      {/* Second Row - Image + Card 2 */}
      <div className="borderline-leftside">
        <div className="borderline-leftside-child"></div>
      </div>

      <div className="PricingSection-container-two" id="booster-card">
        <div className="PricingSection-pricing-row-two PricingSection-row-with-image">
          <div className="PricingSection-left-image">
            <img
              src="/advert-info/Asset img.svg"
              alt=""
              className="PricingSection-illustration"
            />
          </div>
          {/* towpcopy */}
          <div className="cardtwo-right-card-para">
            <div className="PricingSection-card-wrapper">
              <div className="PricingSection-step-number">2</div>
              <div className="PricingSection-badge PricingSection-badge-gratuit">
                dès 1€ / day
              </div>

              <div className="PricingSection-pricing-card">
                <div className="PricingSection-card-content">
                  <div className="PricingSection-icon-wrapper">
                    <img
                      src="/advert-info/Asset img2.svg"
                      alt=""
                      className="PricingSection-calendar-icon"
                    />
                  </div>

                  <h3 className="PricingSection-card-title">
                    Booster ton activité
                  </h3>
                </div>
              </div>
            </div>

            <div className="PricingSection-text-content">
              <div className=" card1pricing-content ">
                <div className="two-left-para-lines-two">
                  <div className="PricingSection-side-text">
                    Fais-toi connaître sur les pages d’événements de ton choix.
                    Des tarifs accessibles à tous, petits ou grands.
                  </div>
                </div>
                <div className="PARTI-card1-btn ">
                  <Link
                    href="/campaigns/createSepCampaigns"
                    className="PricingSection-btn-two PricingSection-btn-primary"
                  >
                    ESSAYER DÈS 1 €
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* ..........................................................................section 3/////////////////////////////////////////////////////////////////////////// */}
      <section className="pricesection-visibility-section">
        <div className="pricesection-container">
          {/* Main Heading with top border */}
          <div className="pricesection-heading-wrapper">
            <h2 className="pricesection-main-heading">
              ...obtiens un max de visibilité partout, <br />
              <span> sur le web et nos applis ! </span>
            </h2>
          </div>

          {/* Cards Row */}
          <div className="pricesection-cards-row">
            {/* Card 1 - City Hub */}
            <div className="pricesection-card-wrapper-container-one">
              <div className="pricesection-card-wrapper">
                <div className="pricesection-card-number">3</div>
                <div className="pricesection-card">
                  <div className="pricesection-card-content">
                    <div className="pricesection-icon-wrapper">
                      <img
                        src="/advert-info/Asset img3.svg"
                        alt="Eiffel Tower"
                        className="pricesection-card-icon"
                      />
                    </div>
                    <h3 className="pricesection-card-title">
                      Les Pages 'City Hub'
                    </h3>
                  </div>
                </div>
                <div className="price-section-main-main">
                  <div className="pricesection-card-description">
                    Apparaît sur les pages City Hub
                    <br />
                    et fais-toi voir par un public vraiment captif.
                    <br />
                    Ces pages sont super fréquentées !
                  </div>
                  <div
                    className="card2-price-btn"
                    style={{ alignItems: "center" }}
                  >
                    <Link
                      href="/campaigns/createHubPageAdvert"
                      className="pricesection-card-button pricesection-card-button-primary"
                    >
                      <p style={{ lineHeight: 1.1 }}> CHARGER TON </p>
                      <p
                        style={{
                          lineHeight: 1.1,
                          justifySelf: "center",
                        }}
                      >
                        {" "}
                        ACTIVITÉ{" "}
                      </p>
                    </Link>
                  </div>
                </div>
              </div>
            </div>

            {/* Card 2 - Categories */}
            <div className="pricesection-two-wrapper-container-two">
              <div className="pricesection-card-wrapper">
                <div className="pricesection-card-number">4</div>
                <div className="pricesection-card">
                  <div className="pricesection-card-content">
                    <div className="pricesection-icon-wrapper">
                      <img
                        src="/advert-info/categories_icon.png"
                        alt="Categories"
                        className="pricesection-card-icon"
                      />
                    </div>
                    <h3 className="pricesection-card-title">
                      Pages Catégories
                    </h3>
                  </div>
                </div>
                <div className="price-section-main-main">
                  <div className="pricesection-card-description">
                    C'est là que les gens fouillent par catégorie.
                    <br />
                    Les pages les plus consultées pour un max
                    <br />
                    d'expo !
                  </div>
                  <div className="card2-price-btn">
                    <Link
                      href="/campaigns/createCategoryPageAdvert"
                      className="pricesection-card-button pricesection-card-button-secondary  pricecard-need-somespace"
                    >
                      SE LANCER
                    </Link>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
