import React from "react";
import Image from "next/image";
import "./loginEmail.css";

interface LoginEmailProps {
  handleMailLoginClick: () => void;
}

const LoginEmail: React.FC<LoginEmailProps> = ({ handleMailLoginClick }) => {
  return (
    <div
      className="color-block-register block-gray-register"
      onClick={handleMailLoginClick}
      style={{ cursor: "pointer" }}
      role="button"
      tabIndex={0}
      onKeyDown={(e) => {
        if (e.key === "Enter" || e.key === " ") {
          handleMailLoginClick();
        }
      }}
      aria-label="Continue with email and password"
    >
      <div className="block-icon-container-register">
        <Image
          src="/login/mail.png"
          alt="Email icon"
          width={24}
          height={24}
          className="block-icon"
          priority={false}
        />
      </div>
      <div className="block-text-content-register">
        <div className="primary-text-breakline-register">
          <span>Continuer avec votre e-mail</span>
          <br />
          <span className="topspace-text">et mot de passe</span>
        </div>
      </div>
    </div>
  );
};

export default LoginEmail;