// components/SubHeaderCard.tsx
import React from 'react';
import "./subheading.css"
interface SubHeaderCardProps {
  /**
   * First line of text
   */
  line1?: string;
  /**
   * Second line of text
   */
  line2?: string;
  /**
   * Container CSS class name
   */
  className?: string;
  /**
   * Whether to use the original styling
   */
  useOriginalStyling?: boolean;
  /**
   * Text CSS class name
   */
  textClassName?: string;
  /**
   * Paragraph CSS class name
   */
  paragraphClassName?: string;
}

const SubHeaderCard: React.FC<SubHeaderCardProps> = ({
  line1 = "Aucun problème ! Remplissez le formulaire ci-dessous",
  line2 = "Nous vous reconnecterons à votre compte en quelques clics",
  className = "",
  useOriginalStyling = true,
  textClassName = "",
  paragraphClassName = "",
}) => {
  // For original styling, use the original class names
  const containerClasses = useOriginalStyling 
    ? `subheading-text-forg ${className}`
    : `subheader-card ${className}`;

  const textClasses = useOriginalStyling
    ? `${textClassName}`.trim() // Original doesn't have a text class
    : `subheader-card-text ${textClassName}`;

  const paraClasses = paragraphClassName || "";

  return (
    <div className={containerClasses}>
      <p className={`${textClasses} ${paraClasses}`.trim()}>{line1}</p>
      <p className={`${textClasses} ${paraClasses}`.trim()}>{line2}</p>
    </div>
  );
};

export default SubHeaderCard;