"use client";

import React, { useState } from "react";
import "./verifyCodeRegister.css";
import Image from "next/image";
import { useRouter } from "next/navigation";
import { verifyEmailCode } from "../../../redux/services/auth/authServices";
import { useDispatch } from "react-redux";
import Swal from "sweetalert2";
import FormInput from "@/app/components/auth/commons/cards/Lable";
import HeaderCard from "@/app/components/auth/commons/cards/HeadingCard";
import SubHeaderCard from "@/app/components/auth/commons/cards/SubHeadingCard";
export const VerifyCodeRegister = ({
  email,
  verificationCode,
  setVerificationCode,
}: {
  email: any;
  verificationCode: any;
  setVerificationCode: any;
}) => {
  const router = useRouter();
  const dispatch = useDispatch();
  const [isLoading, setIsLoading] = useState(false);
  const handleVerifyCode = async () => {
    if (!verificationCode || verificationCode.trim() === "") {
      Swal.fire({
        icon: "warning",
        title: "Champ obligatoire",
        text: "Veuillez saisir le code de vérification",
        confirmButtonText: "OK",
      });
      return;
    }

    setIsLoading(true);
    try {
      const result = await dispatch(
        verifyEmailCode({ code: verificationCode }) as any
      ).unwrap();
      Swal.fire({
        icon: "success",
        title: "Code vérifié !",
        text: "Code de vérification validé avec succès!",
        confirmButtonText: "OK",
      }).then((result) => {
        if (result.isConfirmed) {
          router.push("/login");
        }
      });
    } catch (error: unknown) {
      const errorMessage =
        error instanceof Error ? error.message : String(error);

      Swal.fire({
        icon: "error",
        title: "Échec de la vérification",
        text: "",
        confirmButtonText: "OK",
      });
    } finally {
      setIsLoading(false);
    }
  };
  return (
    <div className="split-forget-container">
      {/* Blue section (70%) */}
      {/* <div className="blue-forget-section"> */}
      <div className="white-forget-center-container">
        <div className="forgot-password-content">
          <div className="forgot-password-image">
            <Image
              src="/login/logo_1.png" // Update with your actual image path
              alt=""
              width={65}
              height={60}
            />
            <p className="forgot-password-title">
              Vérification du compte par code
            </p>
          </div>
          <SubHeaderCard
            line1="Un code de vérification vous a été envoyé par e-mail."
            line2="et nous vous reconnecterons à votre compte en quelques clics"
            useOriginalStyling={true}
          />

          <div className="email-input-container">
            <FormInput
              label="Code de vérification"
              name="email-input"
              type="text"
              value={verificationCode}
              onChange={(fieldName, fieldValue) =>
                setVerificationCode(fieldValue)
              }
              placeholder="Saisissez votre adresse e-mail"
              required
              containerWidth="full"
            />
          </div>
          <div className="retrieve-forget-password-button">
            <button
              className="blue-forget-button"
              disabled={isLoading}
              onClick={handleVerifyCode}
            >
              {isLoading ? "Vérification..." : "Vérifier"}
              <Image
                src="/login/arrow.png"
                alt="Récupérer"
                width={16}
                height={16}
                className="button-icon"
                style={{ marginLeft: "5px" }}
              />
            </button>
          </div>
        </div>
      </div>
    </div>
    // </div>
  );
};
