import type { Metadata } from "next";
import AdvertOurStatistics from "@/app/(main)/home/AdvertOurStatistics";
import FutureClientsSection from "@/app/(main)/home/FutureClienteleSection";
import PricingSection from "@/app/(main)/home/PricingSection";
import PricingTable from "@/app/(main)/home/AdvertTable";
import FAQ from "@/app/(main)/home/FAQ";
import AdvertInfo from "@/app/(main)/home/AdvertInfo";
import FooterNew from "./(main)/footer/FooterNew";

export const metadata: Metadata = {
  title: "Booster votre biz avec nous | Self Serve Portal",
  description:
    "Des événements, oui. Mais après ? Les participants ont soif de nouvelles aventures. Découvrez nos solutions publicitaires pour booster votre activité avec des annonces sur les pages catégorie, à partir de 75€/semaine.",
  keywords: [
    "publicité événements",
    "annonces catégorie",
    "marketing événementiel",
    "self serve portal",
    "publicité digitale",
    "boost annonce",
    "campagne publicitaire",
  ],
  authors: [{ name: "Self Serve Portal" }],
  creator: "Self Serve Portal",
  publisher: "Self Serve Portal",
  openGraph: {
    title: "Booster votre biz avec nous | Self Serve Portal",
    description:
      "Des événements, oui. Mais après ? Les participants ont soif de nouvelles aventures. Découvrez nos solutions publicitaires pour booster votre activité.",
    url: "https://self-serve-portal.eventx.fr",
    siteName: "Self Serve Portal",
    locale: "fr_FR",
    type: "website",
    images: [
      {
        url: "/advert-info/juggler.png",
        width: 1200,
        height: 630,
        alt: "Booster votre business avec Self Serve Portal",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Booster votre biz avec nous | Self Serve Portal",
    description:
      "Des événements, oui. Mais après ? Les participants ont soif de nouvelles aventures. Découvrez nos solutions publicitaires.",
    images: ["/advert-info/juggler.png"],
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      "max-video-preview": -1,
      "max-image-preview": "large",
      "max-snippet": -1,
    },
  },
  alternates: {
    canonical: "https://self-serve-portal.eventx.fr",
  },
};

export default function Home() {
  return (
    <>
      <AdvertInfo />

      <AdvertOurStatistics />
      <FutureClientsSection />
      <PricingSection />
      <PricingTable />
      <FAQ />
      <FooterNew />
    </>
  );
}
