import { createAsyncThunk } from "@reduxjs/toolkit";
import axios from "axios";
import { getUserId, getToken } from "@/app/utils/token";

export const fetchCategoriesCampaigns = createAsyncThunk(
  "campaign/fetchCategoriesCampaigns",
  async (_, { rejectWithValue }) => {
    try {
      const baseURL = process.env.NEXT_PUBLIC_API_URL_New;
      const token = getToken();
      const userId = getUserId();

      if (!userId) {
        return rejectWithValue("User ID not found");
      }

      if (!token) {
        return rejectWithValue("Authentication token not found");
      }

      const requestData = {
        // user_id: userId,
        user_id: 292,
        page: 1,
        limit: 100,
      };

      const response = await axios.get(
        `${baseURL}/category-campaigns?userId=${userId}`,
        // `${baseURL}/category-campaigns?userId=292`,
        {
          headers: {
            Authorization: `Bearer ${token}`,
            // Authorization: `Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJldmVudC14eHgiLCJhdWQiOiJldmVudC14eHgiLCJleHAiOjE5MjE3NTczODQsImRhdGEiOnsidXNlcl9pZCI6MjkyLCJuYW1lIjoiSGFpZGVyIEFsaSBLaGFuIiwiZW1haWwiOiJhbGlraGFuaGFpZGVyMDIxQGdtYWlsLmNvbSIsInVzZXJuYW1lIjoiMjA4MTg2NTY1NyJ9LCJpYXQiOjE3NjQwNzczODR9.ZMtXYJPIAP0Eeryruaj4joFcj8ZptDomugnWqymCheU`,
            // "Content-Type": "text/plain",
          },
          data: requestData,
        }
      );

      if (response.data) {
        return {
          data: response.data,
          message: "Campaigns fetched successfully",
        };
      } else {
        return rejectWithValue("No campaigns data received");
      }
    } catch (error: any) {
      const errorMessage =
        error.response?.data?.message ||
        error.response?.data?.error ||
        "Failed to fetch campaigns";
      return rejectWithValue(errorMessage);
    }
  }
);
export const postponeCategoryCampaign = createAsyncThunk(
  "campaign/postponeCategoryCampaign",
  async (
    {
      campaignId,
      page = 1,
      limit = 100,
    }: {
      campaignId: number;
      page?: number;
      limit?: number;
    },
    { rejectWithValue }
  ) => {
    try {
      const baseURL = process.env.NEXT_PUBLIC_API_URL_New;
      const token = getToken();
      const userId = getUserId();

      if (!userId) {
        return rejectWithValue("User ID not found");
      }

      if (!token) {
        return rejectWithValue("Authentication token not found");
      }

      const requestData = {
        user_id: userId,
        page: page,
        limit: limit,
      };

      const response = await axios.post(
        `${baseURL}/category-campaigns/${campaignId}/postpone`,
        requestData,
        {
          headers: {
            Authorization: `Bearer ${token}`,
            "Content-Type": "application/json",
          },
        }
      );

      if (response.data) {
        return {
          data: response.data,
          message: "Campaign postponed successfully",
          campaignId: campaignId,
        };
      } else {
        return rejectWithValue("No response data received");
      }
    } catch (error: any) {
      const errorMessage =
        error.response?.data?.message ||
        error.response?.data?.error ||
        "Failed to postpone campaign";
      return rejectWithValue(errorMessage);
    }
  }
);
export const deleteCategoryCampaign = createAsyncThunk(
  "campaign/deleteCategoryCampaign",
  async (campaignId: number, { rejectWithValue }) => {
    try {
      const baseURL = process.env.NEXT_PUBLIC_API_URL_New;
      const token = getToken();
      const userId = getUserId();

      if (!userId) {
        return rejectWithValue("User ID not found");
      }

      if (!token) {
        return rejectWithValue("Authentication token not found");
      }

      const requestData = {
        user_id: userId,
        page: 1,
        limit: 100,
      };

      const response = await axios.delete(
        `${baseURL}/category-campaigns/${campaignId}`,
        {
          headers: {
            Authorization: `Bearer ${token}`,
            "Content-Type": "application/json",
          },
          data: requestData,
        }
      );

      if (response.data) {
        return {
          data: response.data,
          message: "Campaign deleted successfully",
          campaignId: campaignId,
        };
      } else {
        return rejectWithValue("No response data received");
      }
    } catch (error: any) {
      const errorMessage =
        error.response?.data?.message ||
        error.response?.data?.error ||
        "Failed to delete campaign";
      return rejectWithValue(errorMessage);
    }
  }
);
