"use client";

import React, { useState } from "react";
import "./verifyCodeRegister.css";
import Image from "next/image";
import { useRouter } from "next/navigation";
import { verifyEmailCode } from "../../../redux/services/auth/authServices";
import { useDispatch } from "react-redux";
import Swal from "sweetalert2";
import { useVerifyCodeData } from "@/app/hooks/useData";

export const VerifyCodeRegister = ({
  email,
  verificationCode,
  setVerificationCode,
}: {
  email: any;
  verificationCode: any;
  setVerificationCode: any;
}) => {
  const router = useRouter();
  const dispatch = useDispatch();
  const { data: translations } = useVerifyCodeData();
  const t = translations || {};
  const [isLoading, setIsLoading] = useState(false);
  const handleVerifyCode = async () => {
    setIsLoading(true);
    try {
      const result = await dispatch(
        verifyEmailCode({ code: verificationCode }) as any
      ).unwrap();
      Swal.fire({
        icon: "success",
        title: t.SweetAlert?.Success_Title || "Code Verified!",
        text:
          result.message ||
          t.SweetAlert?.Success_Text ||
          "Verification code verified successfully!",
        confirmButtonText: t.SweetAlert?.Success_Button || "OK",
      }).then((result) => {
        if (result.isConfirmed) {
          router.push("/login");
        }
      });
    } catch (error: unknown) {
      const errorMessage =
        error instanceof Error ? error.message : String(error);

      Swal.fire({
        icon: "error",
        title: t.SweetAlert?.Error_Title || "Verification Failed",
        text: errorMessage,
        confirmButtonText: t.SweetAlert?.Error_Button || "OK",
      });
    } finally {
      setIsLoading(false);
    }
  };
  return (
    <div className="split-forget-container">
      {/* Blue section (70%) */}
      {/* <div className="blue-forget-section"> */}
      <div className="white-forget-center-container">
        <div className="forgot-password-content">
          <div className="forgot-password-image">
            <Image
              src="/login/logo_1.png" // Update with your actual image path
              alt=""
              width={65}
              height={60}
            />
            <p className="forgot-password-title">
              {t.Page?.Title || "Forgot your password?"}
            </p>
          </div>
          <div className="forgot-password-text">
            <p>
              {t.Page?.Description_Line1 ||
                "No problem! Complete the form below"}
            </p>
            <p>
              {t.Page?.Description_Line2 ||
                "and we'll get you logged into your account in a few clicks"}
            </p>
          </div>
          <div className="email-input-container">
            <label className="email-label">
              {t.Form?.Verification_Code_Label || "Verification Code"}
            </label>
            <input
              type="text"
              className="email-input"
              placeholder={
                t.Form?.Verification_Code_Placeholder ||
                "Enter verification code"
              }
              inputMode="numeric"
              value={verificationCode}
              onChange={(e) => setVerificationCode(e.target.value)}
              pattern="[0-9]*"
              maxLength={6}
            />
          </div>
          <div className="retrieve-forget-password-button">
            <button
              className="blue-forget-button"
              disabled={isLoading}
              onClick={handleVerifyCode}
            >
              {isLoading
                ? t.Button?.Verifying || "Verifying..."
                : t.Button?.Verify || "Verify"}
              <Image
                src="/login/arrow.png"
                alt={t.Alt_Text?.Retrieve || "Retrieve"}
                width={16}
                height={16}
                className="button-icon"
                style={{ marginLeft: "5px" }}
              />
            </button>
          </div>
        </div>
      </div>
    </div>
    // </div>
  );
};
