// app/features/campaign/campaignSlice.ts
import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { Campaign } from "@/app/types";
import {fetchCategories} from "@/app/redux/services/main/campaigns/mycampaign"
import {fetchCategoriesCampaigns} from "@/app/redux/services/main/campaigns/categoriescampaigns"
// Campaign Form State Interface
export interface CampaignCategoryFormState {
  media_type: string;
  advert_type: string;
  advert_redirect_url?: string;
  startDate: string;
  endDate: string;
  price: number;
  category: string;
  postcode: string;
  format: string;
  category_id: string ;
  duration: number;
  image:string;
     booster:false,
   booster_price:"",
   activity_title:string,
   activity_description:string,
   activity_commune:string,
    activity_price:string,
    activity_date:string


  // events: any[];
}


interface CampaignCategoryState {
  campaignsCategory: Campaign[];
  selectedCampaignCategory: Campaign | null;
  campaignFormCategory: CampaignCategoryFormState;
  selectedEvents: CampaignCategoryFormState[];
   communeHubs: any[]; 
      categoryHubs: any[]; 
  loading: boolean;
  error: string | null;
  success: boolean;
  loadingCategoryHubs:boolean
}

const initialFormState: CampaignCategoryFormState = {
  media_type: "image",
  advert_type: "large",
  advert_redirect_url:"",
  startDate: "",
  endDate: "",
  price: 0,
  category: "",
  postcode: "",
  format: "400 X 350px",
  category_id:"",
  duration: 0,
  image:"",
   booster:false,
   booster_price:"",
     activity_title:"",
    activity_description:"",
    activity_commune:"",
    activity_price:"",
    activity_date:""
   

};

const initialState: CampaignCategoryState = {
  campaignsCategory: [],
  selectedCampaignCategory: null,
  campaignFormCategory: initialFormState,
  selectedEvents: [],
   communeHubs: [],
   categoryHubs: [],
  loading: false,
  error: null,
  success: false,
    loadingCategoryHubs: false,
};

export const CategorySlice = createSlice({
  name: "category",
  initialState,
  reducers: {
    setSelectedCampaign: (state, action: PayloadAction<Campaign | null>) => {
      state.selectedCampaignCategory = action.payload;
    },
    clearSelectedCampaign: (state) => {
      state.selectedCampaignCategory = null;
    },

    updateCampaignCategoryFormAlt: (
      state: CampaignCategoryState,
      action: PayloadAction<{
        key: keyof CampaignCategoryFormState;
        value: string | number | any[] | boolean;
      }>
    ) => {
      const { key, value } = action.payload;
      (state.campaignFormCategory as any)[key] = value;
    },

    setCampaignForm: (
      state,
      action: PayloadAction<Partial<CampaignCategoryFormState>>
    ) => {
      state.campaignFormCategory = { ...state.campaignFormCategory, ...action.payload };
    },

    resetCampaignForm: (state) => {
      state.campaignFormCategory = initialFormState;
    },

   
    
       removeFromSelectedEvents: (state, action: PayloadAction<string>) => {
      state.selectedEvents = state.selectedEvents.filter(
        event => event.category_id !== action.payload
      );
    },

    resetCampaignState: () => initialState,
     resetPrice: (state) => {
      state.campaignFormCategory.price = 0;
    },
  },
   extraReducers: (builder) => {
    builder
      // Handle fetchCategories actions
      .addCase(fetchCategories.pending, (state) => {
        state.loadingCategoryHubs = true;
        state.error = null;
      })
      .addCase(fetchCategories.fulfilled, (state, action) => {
        state.loadingCategoryHubs = false;
        state.communeHubs = action.payload.data;
      })
      .addCase(fetchCategories.rejected, (state, action) => {
        state.loadingCategoryHubs = false;
        state.error = action.payload as string;
      })
      .addCase(fetchCategoriesCampaigns.pending, (state) => {
        state.loadingCategoryHubs = true;
        state.error = null;
      })
      .addCase(fetchCategoriesCampaigns.fulfilled, (state, action) => {
        state.loadingCategoryHubs = false;
        state.categoryHubs = action.payload.data;
      })
      .addCase(fetchCategoriesCampaigns.rejected, (state, action) => {
        state.loadingCategoryHubs = false;
        state.error = action.payload as string;
      })
  },
});

export const {
  setSelectedCampaign,
  clearSelectedCampaign,
  updateCampaignCategoryFormAlt,
  setCampaignForm,
  resetCampaignForm,
  resetCampaignState,
  resetPrice,
  removeFromSelectedEvents
} = CategorySlice.actions;

export default CategorySlice.reducer;
