import React, { useState } from "react";
import Image from "next/image";
import "../login/Login.css";
import { EyeClosedIcon, EyeOpenIcon } from "./Eyes";
interface ShowLoginFormProps {
  // Input values
  email: string;
  password: string;
  isLoading: boolean;

  // Change handlers
  onEmailChange: (value: string) => void;
  onPasswordChange: (value: string) => void;

  // Click handlers
  onForgotPasswordClick: () => void;
  onLoginClick: () => void;
  onBackClick: () => void;
}

export const ShowLoginForm: React.FC<ShowLoginFormProps> = ({
  email,
  password,
  isLoading,
  onEmailChange,
  onPasswordChange,
  onForgotPasswordClick,
  onLoginClick,
  onBackClick,
}) => {
  const [showPassword, setShowPassword] = useState(false);

  const togglePasswordVisibility = () => {
    setShowPassword(!showPassword);
  };

  return (
    <div className="color-block-login block-white">
      <div className="block-icon-white-container"></div>
      <div className="block-white-text-content">
        <input
          type="text"
          className="input-line"
          placeholder="Adresse e-mail"
          value={email}
          onChange={(e) => onEmailChange(e.target.value)}
          disabled={isLoading}
        />

        {/* Password input with visibility toggle */}
        <div className="relative">
          <input
            type={showPassword ? "text" : "password"}
            className="input-line pr-10" // Added padding for the eye icon
            placeholder="et mot de passe"
            value={password}
            onChange={(e) => onPasswordChange(e.target.value)}
            disabled={isLoading}
          />
          <button
            type="button"
            className="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-500 hover:text-gray-700 focus:outline-none"
            onClick={togglePasswordVisibility}
            disabled={isLoading}
            aria-label={showPassword ? "Hide password" : "Show password"}
          >
            {showPassword ? <EyeClosedIcon /> : <EyeOpenIcon />}
          </button>
        </div>

        <div
          className="forget-pass-other"
          onClick={onForgotPasswordClick}
          style={{ cursor: "pointer" }}
        >
          Mot de passe oublié ?
        </div>
        <button
          className="login-button"
          onClick={onLoginClick}
          disabled={isLoading}
        >
          {isLoading ? "Connexion en cours..." : "Se connecter"}
        </button>
      </div>
      <div className="block-icon-white-container-right">
        <Image
          src="/login/arrow_email.png"
          alt="Icône"
          width={24}
          height={24}
          className="block-icon"
          onClick={onBackClick}
        />
      </div>
    </div>
  );
};
