"use client";

import { ReactNode } from "react";
import { Elements } from '@stripe/react-stripe-js';
import { loadStripe } from '@stripe/stripe-js';

const stripePromise = loadStripe(process.env.NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY!);

interface StripeProviderProps {
  clientSecret: string;
  children: ReactNode;
}

export default function StripeProvider({ clientSecret, children }: StripeProviderProps) {
  const appearance = {
    theme: 'stripe' as const,
  };

  if (!clientSecret) {
    return <div>Loading payment...</div>;
  }

  return (
    <Elements stripe={stripePromise} options={{ appearance, clientSecret }}>
      {children}
    </Elements>
  );
}